# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ...core.pydantic_utilities import IS_PYDANTIC_V2
from ...core.serialization import FieldMetadata
from .app_user import AppUser
from .entity_id import EntityId


class AppUserResponse(AppUser):
    """
    Examples
    --------
    from mavenagi.commons import (
        AppUserIdentifier,
        AppUserResponse,
        EntityId,
        UserData,
    )

    AppUserResponse(
        user_id=EntityId(
            reference_id="user-0",
            app_id="myapp",
            organization_id="acme",
            agent_id="support",
            type="USER_PROFILE",
        ),
        identifiers=[
            AppUserIdentifier(
                value="joe@myapp.com",
                type="EMAIL",
            )
        ],
        data={
            "name": UserData(
                value="Joe",
                visibility="VISIBLE",
            )
        },
        all_user_data={"myapp": {"name": "Joe"}},
        default_user_data={"name": "Joe"},
    )
    """

    user_id: typing_extensions.Annotated[EntityId, FieldMetadata(alias="userId")] = pydantic.Field()
    """
    ID that uniquely identifies this user
    """

    all_user_data: typing_extensions.Annotated[
        typing.Dict[str, typing.Dict[str, str]], FieldMetadata(alias="allUserData")
    ] = pydantic.Field()
    """
    Data from all apps
    """

    default_user_data: typing_extensions.Annotated[typing.Dict[str, str], FieldMetadata(alias="defaultUserData")] = (
        pydantic.Field()
    )
    """
    Default data for this user
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
