# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ...core.pydantic_utilities import IS_PYDANTIC_V2
from ...core.serialization import FieldMetadata
from .base_attachment import BaseAttachment
from .entity_id_base import EntityIdBase


class AttachmentRequest(BaseAttachment):
    """
    Attachments can be created either with inline data (up to 5MB) using the `content` field or by
    referencing an asynchronously uploaded asset using the `assetId` field.

    See the Assets APIs for more details on how to upload assets and get an asset ID.

    <Tip>
      Due to backwards compatibility, both the `type` field and the `name` field are present when attaching an Asset by ID.
      These fields will be ignored in favor of the values supplied during the initial Asset upload.
      They are only used for inline content uploads.
    </Tip>
    """

    content: typing.Optional[str] = pydantic.Field(default=None)
    """
    Inline attachment data, up to 5MB.
    """

    asset_id: typing_extensions.Annotated[typing.Optional[EntityIdBase], FieldMetadata(alias="assetId")] = (
        pydantic.Field(default=None)
    )
    """
    The ID of an asynchronously uploaded asset.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
