# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ...core.pydantic_utilities import IS_PYDANTIC_V2
from ...core.serialization import FieldMetadata
from .attachment_status import AttachmentStatus
from .base_attachment import BaseAttachment


class AttachmentResponse(BaseAttachment):
    url: typing.Optional[str] = pydantic.Field(default=None)
    """
    The URL to access the attachment, The URL will be valid for 20 minutes. Only present when status is `ACCEPTED`.
    """

    size_bytes: typing_extensions.Annotated[typing.Optional[int], FieldMetadata(alias="sizeBytes")] = pydantic.Field(
        default=None
    )
    """
    The size of the attachment in bytes
    """

    status: AttachmentStatus = pydantic.Field()
    """
    The processing status of the attachment.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
