# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ...core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel


class BaseAttachment(UniversalBaseModel):
    type: str = pydantic.Field()
    """
    The mime-type of the attachment. Supported types are:
    - image/jpeg
    - image/jpg
    - image/png
    - image/gif
    - image/webp
    - application/pdf
    - text/plain
    - text/csv
    - application/vnd.openxmlformats-officedocument.wordprocessingml.document
    - application/vnd.openxmlformats-officedocument.spreadsheetml.sheet
    - application/vnd.openxmlformats-officedocument.presentationml.presentation
    - application/msword
    - application/vnd.ms-excel
    - application/vnd.ms-powerpoint
    - audio/aac
    - audio/mpeg
    - audio/mp4
    - audio/wav
    - audio/ogg
    - video/mp4
    - video/webm
    """

    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    An optional name for the attachment.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
