# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
import typing_extensions
from ...core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ...core.serialization import FieldMetadata
from .conversation_analysis import ConversationAnalysis
from .conversation_summary import ConversationSummary
from .entity_id import EntityId
from .response_config import ResponseConfig


class BaseConversationResponse(UniversalBaseModel):
    response_config: typing_extensions.Annotated[
        typing.Optional[ResponseConfig], FieldMetadata(alias="responseConfig")
    ] = pydantic.Field(default=None)
    """
    Optional configurations for responses to this conversation
    """

    subject: typing.Optional[str] = pydantic.Field(default=None)
    """
    The subject of the conversation
    """

    url: typing.Optional[str] = pydantic.Field(default=None)
    """
    The url of the conversation
    """

    created_at: typing_extensions.Annotated[typing.Optional[dt.datetime], FieldMetadata(alias="createdAt")] = (
        pydantic.Field(default=None)
    )
    """
    The date and time the conversation was created
    """

    updated_at: typing_extensions.Annotated[typing.Optional[dt.datetime], FieldMetadata(alias="updatedAt")] = (
        pydantic.Field(default=None)
    )
    """
    The date and time the conversation was last updated
    """

    tags: typing.Optional[typing.Set[str]] = pydantic.Field(default=None)
    """
    The tags of the conversation. Used for filtering in Agent Designer.
    """

    metadata: typing.Optional[typing.Dict[str, str]] = pydantic.Field(default=None)
    """
    The metadata of the conversation supplied by the app which created the conversation.
    """

    all_metadata: typing_extensions.Annotated[
        typing.Dict[str, typing.Dict[str, str]], FieldMetadata(alias="allMetadata")
    ] = pydantic.Field()
    """
    All metadata for the conversation. Keyed by appId.
    """

    conversation_id: typing_extensions.Annotated[EntityId, FieldMetadata(alias="conversationId")] = pydantic.Field()
    """
    The ID that uniquely identifies this conversation
    """

    analysis: ConversationAnalysis = pydantic.Field()
    """
    An analysis of the conversation. Fields are generated by Maven via an analysis of user messages. This object is calculated on a delay. Fields will not be up to date on ask requests.
    """

    summary: ConversationSummary = pydantic.Field()
    """
    A summary of the conversation. Fields are calculated from conversation data. Unlike analysis, all fields can be derived from other data available in the API. This object is provided as a convenience and is calculated on a delay. Fields will not be up to date on ask requests.
    """

    deleted: bool = pydantic.Field()
    """
    Whether the conversation user-specific data has been deleted. See `deleteConversation` for details.
    """

    open: bool = pydantic.Field()
    """
    Whether the conversation is able to receive asynchronous messages. 
    Only applicable if a conversation is initialized with the `ASYNC` capability. Defaults to true. Can be closed using the `PATCH` API.
    """

    llm_enabled: typing_extensions.Annotated[bool, FieldMetadata(alias="llmEnabled")] = pydantic.Field()
    """
    Whether the LLM is enabled for this conversation. 
    If true, `USER` messages sent via the ask API will be sent to the LLM and a `BOT_RESPONSE` or `BOT_SUGGESTION` message will be generated. 
    If false, `USER` messages will not be sent to the LLM.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
