# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ...core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ...core.serialization import FieldMetadata
from .action_form_field import ActionFormField
from .entity_id_without_agent import EntityIdWithoutAgent


class BotActionFormResponse(UniversalBaseModel):
    """
    This response should be rendered as a form which users can submit. Upon submission call the `submitActionForm` API.
    """

    id: str = pydantic.Field()
    """
    The ID to use when submitting the form via the `submitActionForm` API.
    """

    action_id: typing_extensions.Annotated[EntityIdWithoutAgent, FieldMetadata(alias="actionId")] = pydantic.Field()
    """
    The ID of the action that will be executed when the form is submitted.
    """

    form_label: typing_extensions.Annotated[str, FieldMetadata(alias="formLabel")] = pydantic.Field()
    """
    Text which should be displayed to the user at the top of the form. Provided in the user's language.
    """

    fields: typing.List[ActionFormField] = pydantic.Field()
    """
    The fields that should be displayed within the form.
    """

    submit_label: typing_extensions.Annotated[str, FieldMetadata(alias="submitLabel")] = pydantic.Field()
    """
    Text that should be displayed to the user on the submit button. Provided in the user's language.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
