# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ...core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ...core.serialization import FieldMetadata
from .chart_spec_schema import ChartSpecSchema


class BotChartResponse(UniversalBaseModel):
    """
    Will only be provided if the responseConfig contains the charts_highcharts_ts capability.
    """

    label: str = pydantic.Field()
    """
    The label of the chart
    """

    spec_schema: typing_extensions.Annotated[ChartSpecSchema, FieldMetadata(alias="specSchema")]
    spec: str = pydantic.Field()
    """
    The spec string for the chart. For HIGHCHARTS_TS charts, the spec is the json object that represents the chart options.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
