# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import typing

import pydantic
import typing_extensions
from ...core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ...core.serialization import FieldMetadata
from .action_execution_param_value import ActionExecutionParamValue
from .bot_logic_action_executed_detail import BotLogicActionExecutedDetail
from .bot_logic_action_reviewed_detail import BotLogicActionReviewedDetail
from .bot_logic_knowledge_detail import BotLogicKnowledgeDetail
from .entity_id import EntityId
from .entity_id_without_agent import EntityIdWithoutAgent


class BotLogicItem_Knowledge(UniversalBaseModel):
    type: typing.Literal["knowledge"] = "knowledge"
    knowledge_reviewed: typing_extensions.Annotated[
        typing.List[BotLogicKnowledgeDetail], FieldMetadata(alias="knowledgeReviewed")
    ]
    knowledge_utilized: typing_extensions.Annotated[
        typing.List[BotLogicKnowledgeDetail], FieldMetadata(alias="knowledgeUtilized")
    ]

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


class BotLogicItem_Actions(UniversalBaseModel):
    type: typing.Literal["actions"] = "actions"
    actions_reviewed: typing_extensions.Annotated[
        typing.List[BotLogicActionReviewedDetail], FieldMetadata(alias="actionsReviewed")
    ]
    actions_executed: typing_extensions.Annotated[
        typing.List[BotLogicActionExecutedDetail], FieldMetadata(alias="actionsExecuted")
    ]

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


class BotLogicItem_Form(UniversalBaseModel):
    type: typing.Literal["form"] = "form"
    action_parameters: typing_extensions.Annotated[
        typing.Dict[str, ActionExecutionParamValue], FieldMetadata(alias="actionParameters")
    ]
    execution_result: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="executionResult")] = None
    execution_error: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="executionError")] = None
    action_id: typing_extensions.Annotated[EntityIdWithoutAgent, FieldMetadata(alias="actionId")]
    action_name: typing_extensions.Annotated[str, FieldMetadata(alias="actionName")]

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


class BotLogicItem_Safety(UniversalBaseModel):
    type: typing.Literal["safety"] = "safety"
    safety_check_passed: typing_extensions.Annotated[bool, FieldMetadata(alias="safetyCheckPassed")]

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


class BotLogicItem_User(UniversalBaseModel):
    type: typing.Literal["user"] = "user"
    user_data: typing_extensions.Annotated[typing.Dict[str, str], FieldMetadata(alias="userData")]

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


class BotLogicItem_Segments(UniversalBaseModel):
    type: typing.Literal["segments"] = "segments"
    matching_segment_ids: typing_extensions.Annotated[typing.List[EntityId], FieldMetadata(alias="matchingSegmentIds")]

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


BotLogicItem = typing.Union[
    BotLogicItem_Knowledge,
    BotLogicItem_Actions,
    BotLogicItem_Form,
    BotLogicItem_Safety,
    BotLogicItem_User,
    BotLogicItem_Segments,
]
