# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ...core.pydantic_utilities import IS_PYDANTIC_V2
from ...core.serialization import FieldMetadata
from .bot_conversation_message_type import BotConversationMessageType
from .bot_logic import BotLogic
from .bot_response import BotResponse
from .bot_response_metadata import BotResponseMetadata
from .conversation_message_base import ConversationMessageBase
from .entity_id import EntityId
from .message_status import MessageStatus


class BotMessage(ConversationMessageBase):
    conversation_message_id: typing_extensions.Annotated[EntityId, FieldMetadata(alias="conversationMessageId")] = (
        pydantic.Field()
    )
    """
    The ID that uniquely identifies this message within the conversation
    """

    bot_message_type: typing_extensions.Annotated[BotConversationMessageType, FieldMetadata(alias="botMessageType")]
    responses: typing.List[BotResponse]
    metadata: BotResponseMetadata
    status: MessageStatus
    logic: typing.Optional[BotLogic] = pydantic.Field(default=None)
    """
    The logic that was used to generate the response. Response size may be large; only present on the getConversation request.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
