# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ...core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ...core.serialization import FieldMetadata


class BotOAuthButtonResponse(UniversalBaseModel):
    """
    This response should be rendered as a single button that starts an OAuth authorization flow.
    """

    button_name: typing_extensions.Annotated[str, FieldMetadata(alias="buttonName")] = pydantic.Field()
    """
    Text that should be displayed to the user on the button.
    """

    url: str = pydantic.Field()
    """
    The OAuth authorization URL to open when the button is clicked.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
