# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ...core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel


class BotObjectResponse(UniversalBaseModel):
    """
    A structured object generated by the bot in response to a schema-based generateObject request. Should be rendered as JSON.
    """

    label: typing.Optional[str] = pydantic.Field(default=None)
    """
    A human-readable name for the generated object, for use in the UI.
    """

    object: typing.Optional[typing.Any] = pydantic.Field(default=None)
    """
    The generated object conforming to the provided schema.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
