# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import typing

import pydantic
import typing_extensions
from ...core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ...core.serialization import FieldMetadata
from .action_form_field import ActionFormField
from .chart_spec_schema import ChartSpecSchema
from .entity_id_without_agent import EntityIdWithoutAgent


class BotResponse_Text(UniversalBaseModel):
    type: typing.Literal["text"] = "text"
    text: str

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


class BotResponse_ActionForm(UniversalBaseModel):
    type: typing.Literal["actionForm"] = "actionForm"
    id: str
    action_id: typing_extensions.Annotated[EntityIdWithoutAgent, FieldMetadata(alias="actionId")]
    form_label: typing_extensions.Annotated[str, FieldMetadata(alias="formLabel")]
    fields: typing.List[ActionFormField]
    submit_label: typing_extensions.Annotated[str, FieldMetadata(alias="submitLabel")]

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


class BotResponse_OauthButton(UniversalBaseModel):
    type: typing.Literal["oauthButton"] = "oauthButton"
    button_name: typing_extensions.Annotated[str, FieldMetadata(alias="buttonName")]
    url: str

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


class BotResponse_Chart(UniversalBaseModel):
    type: typing.Literal["chart"] = "chart"
    label: str
    spec_schema: typing_extensions.Annotated[ChartSpecSchema, FieldMetadata(alias="specSchema")]
    spec: str

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


class BotResponse_Object(UniversalBaseModel):
    type: typing.Literal["object"] = "object"
    label: typing.Optional[str] = None
    object: typing.Optional[typing.Any] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


BotResponse = typing.Union[
    BotResponse_Text, BotResponse_ActionForm, BotResponse_OauthButton, BotResponse_Chart, BotResponse_Object
]
