# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ...core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ...core.serialization import FieldMetadata
from .quality import Quality
from .quality_reason import QualityReason
from .sentiment import Sentiment


class ConversationAnalysis(UniversalBaseModel):
    user_request: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="userRequest")] = (
        pydantic.Field(default=None)
    )
    """
    Generated user request summary of the conversation
    """

    agent_response: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="agentResponse")] = (
        pydantic.Field(default=None)
    )
    """
    Generated agent response summary of the conversation
    """

    resolution_status: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="resolutionStatus")] = (
        pydantic.Field(default=None)
    )
    """
    Generated resolution status of the conversation
    """

    category: typing.Optional[str] = pydantic.Field(default=None)
    """
    Generated category of the conversation
    """

    sentiment: typing.Optional[Sentiment] = pydantic.Field(default=None)
    """
    Generated sentiment of the conversation
    """

    quality: typing.Optional[Quality] = pydantic.Field(default=None)
    """
    Generated quality of the conversation
    """

    quality_reason: typing_extensions.Annotated[
        typing.Optional[QualityReason], FieldMetadata(alias="qualityReason")
    ] = pydantic.Field(default=None)
    """
    If the quality of the conversation is `UNKNOWN` or `NEEDS_IMPROVEMENT` then a reason for the quality will be provided when possible.
    """

    resolved_by_maven: typing_extensions.Annotated[typing.Optional[bool], FieldMetadata(alias="resolvedByMaven")] = (
        pydantic.Field(default=None)
    )
    """
    Whether the conversation was resolved by Maven
    """

    primary_language: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="primaryLanguage")] = (
        pydantic.Field(default=None)
    )
    """
    Primary language of the conversation in ISO 639-1 code format
    """

    predicted_nps: typing_extensions.Annotated[typing.Optional[float], FieldMetadata(alias="predictedNps")] = (
        pydantic.Field(default=None)
    )
    """
    The predicted NPS of the conversation.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
