# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ...core.pydantic_utilities import IS_PYDANTIC_V2
from ...core.serialization import FieldMetadata
from .precondition_base import PreconditionBase


class ConversationExecutedActionPrecondition(PreconditionBase):
    action_id: typing_extensions.Annotated[str, FieldMetadata(alias="actionId")] = pydantic.Field()
    """
    ID of an action that must have executed in this conversation for the precondition to be met
    """

    app_id: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="appId")] = pydantic.Field(
        default=None
    )
    """
    App ID that the given actionId belongs to. If not provided, the calling appId will be used.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
