# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import typing

import pydantic
import typing_extensions
from ...core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ...core.serialization import FieldMetadata
from .precondition_operator import PreconditionOperator
from .response_length import ResponseLength


class ConversationPrecondition_Tags(UniversalBaseModel):
    conversation_precondition_type: typing_extensions.Annotated[
        typing.Literal["tags"], FieldMetadata(alias="conversationPreconditionType")
    ] = "tags"
    tags: typing.Set[str]
    operator: typing.Optional[PreconditionOperator] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


class ConversationPrecondition_Metadata(UniversalBaseModel):
    conversation_precondition_type: typing_extensions.Annotated[
        typing.Literal["metadata"], FieldMetadata(alias="conversationPreconditionType")
    ] = "metadata"
    key: str
    value: typing.Optional[str] = None
    operator: typing.Optional[PreconditionOperator] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


class ConversationPrecondition_ActionExecuted(UniversalBaseModel):
    conversation_precondition_type: typing_extensions.Annotated[
        typing.Literal["actionExecuted"], FieldMetadata(alias="conversationPreconditionType")
    ] = "actionExecuted"
    action_id: typing_extensions.Annotated[str, FieldMetadata(alias="actionId")]
    app_id: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="appId")] = None
    operator: typing.Optional[PreconditionOperator] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


class ConversationPrecondition_ResponseConfig(UniversalBaseModel):
    conversation_precondition_type: typing_extensions.Annotated[
        typing.Literal["responseConfig"], FieldMetadata(alias="conversationPreconditionType")
    ] = "responseConfig"
    use_markdown: typing_extensions.Annotated[typing.Optional[bool], FieldMetadata(alias="useMarkdown")] = None
    use_forms: typing_extensions.Annotated[typing.Optional[bool], FieldMetadata(alias="useForms")] = None
    use_images: typing_extensions.Annotated[typing.Optional[bool], FieldMetadata(alias="useImages")] = None
    is_copilot: typing_extensions.Annotated[typing.Optional[bool], FieldMetadata(alias="isCopilot")] = None
    response_length: typing_extensions.Annotated[
        typing.Optional[ResponseLength], FieldMetadata(alias="responseLength")
    ] = None
    operator: typing.Optional[PreconditionOperator] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


class ConversationPrecondition_App(UniversalBaseModel):
    conversation_precondition_type: typing_extensions.Annotated[
        typing.Literal["app"], FieldMetadata(alias="conversationPreconditionType")
    ] = "app"
    app_id: typing_extensions.Annotated[str, FieldMetadata(alias="appId")]
    operator: typing.Optional[PreconditionOperator] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


ConversationPrecondition = typing.Union[
    ConversationPrecondition_Tags,
    ConversationPrecondition_Metadata,
    ConversationPrecondition_ActionExecuted,
    ConversationPrecondition_ResponseConfig,
    ConversationPrecondition_App,
]
