# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ...core.pydantic_utilities import IS_PYDANTIC_V2
from .attachment_response import AttachmentResponse
from .base_conversation_response import BaseConversationResponse
from .conversation_message_response import ConversationMessageResponse


class ConversationResponse(BaseConversationResponse):
    """
    Examples
    --------
    from mavenagi.commons import (
        AttachmentResponse,
        BotResponse_Text,
        BotResponseMetadata,
        ConversationAnalysis,
        ConversationMessageResponse_Bot,
        ConversationMessageResponse_User,
        ConversationResponse,
        ConversationSummary,
        EntityId,
        EntityIdBase,
    )

    ConversationResponse(
        conversation_id=EntityId(
            reference_id="conversation-0",
            app_id="myapp",
            organization_id="acme",
            agent_id="support",
            type="CONVERSATION",
        ),
        deleted=False,
        open=False,
        llm_enabled=True,
        analysis=ConversationAnalysis(
            resolution_status="Resolved",
            sentiment="POSITIVE",
            resolved_by_maven=True,
        ),
        summary=ConversationSummary(
            action_ids=[],
            incomplete_action_ids=[],
            insert_count=0,
            thumbs_up_count=0,
            thumbs_down_count=0,
            user_message_count=1,
            human_agents=[],
            human_agents_with_inserts=[],
            users=[],
        ),
        metadata={},
        all_metadata={},
        attachments=[],
        messages=[
            ConversationMessageResponse_User(
                user_message_type="USER",
                conversation_message_id=EntityId(
                    reference_id="message-0",
                    app_id="myapp",
                    organization_id="acme",
                    agent_id="support",
                    type="CONVERSATION_MESSAGE",
                ),
                status="UNKNOWN",
                user_id=EntityIdBase(
                    reference_id="user-0",
                ),
                text="How do I reset my password?",
                attachments=[
                    AttachmentResponse(
                        url="https://example.com/attachment-0",
                        type="image/png",
                        status="ACCEPTED",
                        size_bytes=1234,
                    )
                ],
            ),
            ConversationMessageResponse_Bot(
                bot_message_type="BOT_RESPONSE",
                conversation_message_id=EntityId(
                    reference_id="message-1",
                    app_id="myapp",
                    organization_id="acme",
                    agent_id="support",
                    type="CONVERSATION_MESSAGE",
                ),
                status="SENT",
                responses=[
                    BotResponse_Text(
                        text="Hi! Go to acme.com/reset-password",
                    )
                ],
                metadata=BotResponseMetadata(
                    followup_questions=["What if I did not get the reset email?"],
                    sources=[],
                ),
            ),
        ],
    )
    """

    messages: typing.List[ConversationMessageResponse] = pydantic.Field()
    """
    The messages in the conversation
    """

    attachments: typing.List[AttachmentResponse] = pydantic.Field()
    """
    The attachments associated with this conversation. Additional attachments may be associated to individual messages.
    
    Message attachments are included in LLM context, conversation attachments are not.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
