# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ...core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ...core.serialization import FieldMetadata
from .entity_id_without_agent import EntityIdWithoutAgent


class DocumentInformation(UniversalBaseModel):
    knowledge_base_id: typing_extensions.Annotated[EntityIdWithoutAgent, FieldMetadata(alias="knowledgeBaseId")] = (
        pydantic.Field()
    )
    """
    Unique identifier for the knowledge base.
    """

    document_id: typing_extensions.Annotated[EntityIdWithoutAgent, FieldMetadata(alias="documentId")] = pydantic.Field()
    """
    Unique identifier for the document.
    """

    title: typing.Optional[str] = pydantic.Field(default=None)
    """
    Title of the document.
    """

    snippet: typing.Optional[str] = pydantic.Field(default=None)
    """
    Snippet or summary of the document.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
