# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import datetime as dt
import typing

import pydantic
import typing_extensions
from ...core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ...core.serialization import FieldMetadata
from .context_info import ContextInfo
from .entity_id_base import EntityIdBase
from .event_user_info_base import EventUserInfoBase
from .feedback_info import FeedbackInfo
from .page_info import PageInfo
from .scoped_entity import ScopedEntity
from .session_info import SessionInfo
from .source_info import SourceInfo
from .system_event_name import SystemEventName
from .user_event_name import UserEventName


class EventRequest_UserEvent(UniversalBaseModel):
    event_type: typing_extensions.Annotated[typing.Literal["userEvent"], FieldMetadata(alias="eventType")] = "userEvent"
    id: EntityIdBase
    event_name: typing_extensions.Annotated[UserEventName, FieldMetadata(alias="eventName")]
    user_info: typing_extensions.Annotated[EventUserInfoBase, FieldMetadata(alias="userInfo")]
    feedback_info: typing_extensions.Annotated[
        typing.Optional[typing.List[FeedbackInfo]], FieldMetadata(alias="feedbackInfo")
    ] = None
    page_info: typing_extensions.Annotated[typing.Optional[PageInfo], FieldMetadata(alias="pageInfo")] = None
    timestamp: typing.Optional[dt.datetime] = None
    references: typing.Optional[typing.List[ScopedEntity]] = None
    source_info: typing_extensions.Annotated[typing.Optional[SourceInfo], FieldMetadata(alias="sourceInfo")] = None
    session_info: typing_extensions.Annotated[typing.Optional[SessionInfo], FieldMetadata(alias="sessionInfo")] = None
    context_info: typing_extensions.Annotated[typing.Optional[ContextInfo], FieldMetadata(alias="contextInfo")] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


class EventRequest_SystemEvent(UniversalBaseModel):
    event_type: typing_extensions.Annotated[typing.Literal["systemEvent"], FieldMetadata(alias="eventType")] = (
        "systemEvent"
    )
    id: EntityIdBase
    event_name: typing_extensions.Annotated[SystemEventName, FieldMetadata(alias="eventName")]
    timestamp: typing.Optional[dt.datetime] = None
    references: typing.Optional[typing.List[ScopedEntity]] = None
    source_info: typing_extensions.Annotated[typing.Optional[SourceInfo], FieldMetadata(alias="sourceInfo")] = None
    session_info: typing_extensions.Annotated[typing.Optional[SessionInfo], FieldMetadata(alias="sessionInfo")] = None
    context_info: typing_extensions.Annotated[typing.Optional[ContextInfo], FieldMetadata(alias="contextInfo")] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


EventRequest = typing.Union[EventRequest_UserEvent, EventRequest_SystemEvent]
