# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import datetime as dt
import typing

import pydantic
import typing_extensions
from ...core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ...core.serialization import FieldMetadata
from .context_info import ContextInfo
from .entity_id import EntityId
from .event_user_info import EventUserInfo
from .feedback_info import FeedbackInfo
from .page_info import PageInfo
from .scoped_entity import ScopedEntity
from .session_info import SessionInfo
from .source_info import SourceInfo
from .system_event_name import SystemEventName
from .user_event_name import UserEventName


class EventResponse_UserEvent(UniversalBaseModel):
    event_type: typing_extensions.Annotated[typing.Literal["userEvent"], FieldMetadata(alias="eventType")] = "userEvent"
    id: EntityId
    event_name: typing_extensions.Annotated[UserEventName, FieldMetadata(alias="eventName")]
    user_info: typing_extensions.Annotated[EventUserInfo, FieldMetadata(alias="userInfo")]
    feedback_info: typing_extensions.Annotated[
        typing.Optional[typing.List[FeedbackInfo]], FieldMetadata(alias="feedbackInfo")
    ] = None
    page_info: typing_extensions.Annotated[typing.Optional[PageInfo], FieldMetadata(alias="pageInfo")] = None
    timestamp: typing.Optional[dt.datetime] = None
    references: typing.Optional[typing.List[ScopedEntity]] = None
    source_info: typing_extensions.Annotated[typing.Optional[SourceInfo], FieldMetadata(alias="sourceInfo")] = None
    session_info: typing_extensions.Annotated[typing.Optional[SessionInfo], FieldMetadata(alias="sessionInfo")] = None
    context_info: typing_extensions.Annotated[typing.Optional[ContextInfo], FieldMetadata(alias="contextInfo")] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


class EventResponse_SystemEvent(UniversalBaseModel):
    event_type: typing_extensions.Annotated[typing.Literal["systemEvent"], FieldMetadata(alias="eventType")] = (
        "systemEvent"
    )
    id: EntityId
    event_name: typing_extensions.Annotated[SystemEventName, FieldMetadata(alias="eventName")]
    timestamp: typing.Optional[dt.datetime] = None
    references: typing.Optional[typing.List[ScopedEntity]] = None
    source_info: typing_extensions.Annotated[typing.Optional[SourceInfo], FieldMetadata(alias="sourceInfo")] = None
    session_info: typing_extensions.Annotated[typing.Optional[SessionInfo], FieldMetadata(alias="sessionInfo")] = None
    context_info: typing_extensions.Annotated[typing.Optional[ContextInfo], FieldMetadata(alias="contextInfo")] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


EventResponse = typing.Union[EventResponse_UserEvent, EventResponse_SystemEvent]
