# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
import typing_extensions
from ...core.pydantic_utilities import IS_PYDANTIC_V2
from ...core.serialization import FieldMetadata
from .entity_id import EntityId
from .feedback_base import FeedbackBase


class Feedback(FeedbackBase):
    """
    Examples
    --------
    from mavenagi.commons import EntityId, Feedback

    Feedback(
        feedback_id=EntityId(
            reference_id="feedback-0",
            app_id="myapp",
            organization_id="acme",
            agent_id="support",
            type="FEEDBACK",
        ),
        conversation_id=EntityId(
            reference_id="conversation-0",
            app_id="myapp",
            organization_id="acme",
            agent_id="support",
            type="CONVERSATION",
        ),
        conversation_message_id=EntityId(
            reference_id="message-1",
            app_id="myapp",
            organization_id="acme",
            agent_id="support",
            type="CONVERSATION_MESSAGE",
        ),
        user_id=EntityId(
            reference_id="user-0",
            app_id="myapp",
            organization_id="acme",
            agent_id="support",
            type="USER",
        ),
        type="THUMBS_UP",
        text="Great answer!",
    )
    """

    feedback_id: typing_extensions.Annotated[EntityId, FieldMetadata(alias="feedbackId")] = pydantic.Field()
    """
    The ID of the piece of feedback
    """

    conversation_id: typing_extensions.Annotated[EntityId, FieldMetadata(alias="conversationId")] = pydantic.Field()
    """
    The ID of the conversation the feedback is about
    """

    conversation_message_id: typing_extensions.Annotated[EntityId, FieldMetadata(alias="conversationMessageId")] = (
        pydantic.Field()
    )
    """
    The ID of the conversation message the feedback is about
    """

    user_id: typing_extensions.Annotated[typing.Optional[EntityId], FieldMetadata(alias="userId")] = pydantic.Field(
        default=None
    )
    """
    The ID of the user who created the feedback
    """

    created_at: typing_extensions.Annotated[typing.Optional[dt.datetime], FieldMetadata(alias="createdAt")] = (
        pydantic.Field(default=None)
    )
    """
    The date and time the feedback was created
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
