# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ...core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ...core.serialization import FieldMetadata
from .survey_info import SurveyInfo


class FeedbackInfo(UniversalBaseModel):
    rating: typing.Optional[float] = pydantic.Field(default=None)
    """
    The rating of the feedback as a ratio [0.0, 1.0]
    """

    thumb_up: typing_extensions.Annotated[typing.Optional[bool], FieldMetadata(alias="thumbUp")] = pydantic.Field(
        default=None
    )
    """
    Whether the feedback was marked as a thumbs up
    """

    survey: typing.Optional[SurveyInfo] = pydantic.Field(default=None)
    """
    A question and answer associated with the feedback
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
