# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import datetime as dt
import typing

import pydantic
import typing_extensions
from ...core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ...core.serialization import FieldMetadata
from .conversation_information import ConversationInformation
from .document_information import DocumentInformation
from .entity_id import EntityId
from .inbox_item_fix_add_document import InboxItemFixAddDocument
from .inbox_item_fix_deactivate_document import InboxItemFixDeactivateDocument
from .inbox_item_severity import InboxItemSeverity
from .inbox_item_status import InboxItemStatus


class InboxItem_DuplicateDocuments(UniversalBaseModel):
    type: typing.Literal["duplicateDocuments"] = "duplicateDocuments"
    recommended_fixes: typing_extensions.Annotated[
        typing.List[InboxItemFixDeactivateDocument], FieldMetadata(alias="recommendedFixes")
    ]
    other_fixes: typing_extensions.Annotated[
        typing.List[InboxItemFixDeactivateDocument], FieldMetadata(alias="otherFixes")
    ]
    source_document: typing_extensions.Annotated[DocumentInformation, FieldMetadata(alias="sourceDocument")]
    documents: typing.List[DocumentInformation]
    id: EntityId
    created_at: typing_extensions.Annotated[dt.datetime, FieldMetadata(alias="createdAt")]
    updated_at: typing_extensions.Annotated[dt.datetime, FieldMetadata(alias="updatedAt")]
    status: InboxItemStatus
    severity: InboxItemSeverity

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


class InboxItem_MissingKnowledge(UniversalBaseModel):
    type: typing.Literal["missingKnowledge"] = "missingKnowledge"
    fix: InboxItemFixAddDocument
    conversations: typing.List[ConversationInformation]
    id: EntityId
    created_at: typing_extensions.Annotated[dt.datetime, FieldMetadata(alias="createdAt")]
    updated_at: typing_extensions.Annotated[dt.datetime, FieldMetadata(alias="updatedAt")]
    status: InboxItemStatus
    severity: InboxItemSeverity

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


InboxItem = typing.Union[InboxItem_DuplicateDocuments, InboxItem_MissingKnowledge]
