# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
import typing_extensions
from ...core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ...core.serialization import FieldMetadata
from .entity_id import EntityId
from .inbox_item_severity import InboxItemSeverity
from .inbox_item_status import InboxItemStatus


class InboxItemBase(UniversalBaseModel):
    id: EntityId = pydantic.Field()
    """
    Unique identifier for the inbox item.
    """

    created_at: typing_extensions.Annotated[dt.datetime, FieldMetadata(alias="createdAt")] = pydantic.Field()
    """
    Timestamp when the inbox item was created.
    """

    updated_at: typing_extensions.Annotated[dt.datetime, FieldMetadata(alias="updatedAt")] = pydantic.Field()
    """
    Timestamp when the inbox item was last updated.
    """

    status: InboxItemStatus = pydantic.Field()
    """
    Status of the inbox item.
    """

    severity: InboxItemSeverity = pydantic.Field()
    """
    Severity of the inbox item.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
