# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ...core.pydantic_utilities import IS_PYDANTIC_V2
from ...core.serialization import FieldMetadata
from .document_information import DocumentInformation
from .inbox_item_base import InboxItemBase
from .inbox_item_fix_deactivate_document import InboxItemFixDeactivateDocument


class InboxItemDuplicateDocuments(InboxItemBase):
    recommended_fixes: typing_extensions.Annotated[
        typing.List[InboxItemFixDeactivateDocument], FieldMetadata(alias="recommendedFixes")
    ] = pydantic.Field()
    """
    The fix recommended for being applied
    """

    other_fixes: typing_extensions.Annotated[
        typing.List[InboxItemFixDeactivateDocument], FieldMetadata(alias="otherFixes")
    ] = pydantic.Field()
    """
    List of fixes associated with the inbox item.
    """

    source_document: typing_extensions.Annotated[DocumentInformation, FieldMetadata(alias="sourceDocument")] = (
        pydantic.Field()
    )
    """
    Information about the source document associated with the inbox item.
    """

    documents: typing.List[DocumentInformation] = pydantic.Field()
    """
    List of Document information objects related to the inbox item.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
