# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ...core.pydantic_utilities import IS_PYDANTIC_V2
from ...core.serialization import FieldMetadata
from .entity_id_base import EntityIdBase
from .event_base_no_id import EventBaseNoId
from .event_user_info_base import EventUserInfoBase
from .feedback_info import FeedbackInfo
from .page_info import PageInfo
from .user_event_name import UserEventName


class NovelUserEvent(EventBaseNoId):
    id: EntityIdBase = pydantic.Field()
    """
    The unique ID of the event
    """

    event_name: typing_extensions.Annotated[UserEventName, FieldMetadata(alias="eventName")] = pydantic.Field()
    """
    The name of the event
    """

    user_info: typing_extensions.Annotated[EventUserInfoBase, FieldMetadata(alias="userInfo")] = pydantic.Field()
    """
    Information about the user who triggered the event
    """

    feedback_info: typing_extensions.Annotated[
        typing.Optional[typing.List[FeedbackInfo]], FieldMetadata(alias="feedbackInfo")
    ] = pydantic.Field(default=None)
    """
    Information about any feedback associated with the event
    """

    page_info: typing_extensions.Annotated[typing.Optional[PageInfo], FieldMetadata(alias="pageInfo")] = pydantic.Field(
        default=None
    )
    """
    Information about the page on which the event occurred
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
