# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import typing

import pydantic
import typing_extensions
from ...core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel, update_forward_refs
from ...core.serialization import FieldMetadata
from .conversation_precondition import ConversationPrecondition
from .precondition_group_operator import PreconditionGroupOperator
from .precondition_operator import PreconditionOperator


class Precondition_User(UniversalBaseModel):
    """
    Examples
    --------
    from mavenagi.commons import Precondition_Group, Precondition_User

    Precondition_Group(
        operator="AND",
        preconditions=[
            Precondition_User(
                key="userKey",
            ),
            Precondition_User(
                key="userKey2",
            ),
        ],
    )
    """

    precondition_type: typing_extensions.Annotated[typing.Literal["user"], FieldMetadata(alias="preconditionType")] = (
        "user"
    )
    key: str
    value: typing.Optional[str] = None
    operator: typing.Optional[PreconditionOperator] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


class Precondition_Conversation(UniversalBaseModel):
    value: ConversationPrecondition
    precondition_type: typing_extensions.Annotated[
        typing.Literal["conversation"], FieldMetadata(alias="preconditionType")
    ] = "conversation"

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True


class Precondition_Group(UniversalBaseModel):
    """
    Examples
    --------
    from mavenagi.commons import Precondition_Group, Precondition_User

    Precondition_Group(
        operator="AND",
        preconditions=[
            Precondition_User(
                key="userKey",
            ),
            Precondition_User(
                key="userKey2",
            ),
        ],
    )
    """

    precondition_type: typing_extensions.Annotated[typing.Literal["group"], FieldMetadata(alias="preconditionType")] = (
        "group"
    )
    operator: PreconditionGroupOperator
    preconditions: typing.List["Precondition"]

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


from .precondition_group import PreconditionGroup  # noqa: E402, F401, I001

"""
from mavenagi.commons import Precondition_Group, Precondition_User

Precondition_Group(
    operator="AND",
    preconditions=[
        Precondition_User(
            key="userKey",
        ),
        Precondition_User(
            key="userKey2",
        ),
    ],
)
"""
Precondition = typing.Union[Precondition_User, Precondition_Conversation, Precondition_Group]
update_forward_refs(Precondition_Group)
