# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ...core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ...core.serialization import FieldMetadata
from .capability import Capability
from .response_length import ResponseLength


class ResponseConfig(UniversalBaseModel):
    capabilities: typing.List[Capability] = pydantic.Field()
    """
    List of capabilities supported by the caller. Defaults to `[MARKDOWN, FORMS, IMAGES]`.
    
    - `MARKDOWN`: Whether the response should include markdown formatting. If not provided, the response will be plain text. Not respected while streaming.
    - `FORMS`: Whether the response should include forms. If provided, the caller needs to render action forms when returned from the ask API and allow submission of the forms with the submitActionForm API. If not provided, then actions which require user interaction will not be considered by the LLM. Removing this capability is recommended for surfaces which can not display UI (e.g. SMS, voice).
    - `IMAGES`: Whether the response should include images. Not yet supported.
    - `CHARTS_HIGHCHARTS_TS`: Whether the response should include a Highcharts typescript chart if applicable.
    - `ASYNC`: Whether the app that created this conversation supports asynchronous message delivery. If provided, messages may be sent to the app via the `handleMessage` function.
    - `OAUTH_BUTTONS`: Whether the response should include OAuth buttons. If provided, the caller needs to render OAuth buttons when returned from the ask API and allow the user to click the buttons to initiate the OAuth flow. If not provided, then actions which require OAuth authorization will not be considered by the LLM. This capability is not recommended for surfaces which can not display links (e.g. voice).
    """

    is_copilot: typing_extensions.Annotated[bool, FieldMetadata(alias="isCopilot")] = pydantic.Field()
    """
    Whether the response is for an human agent (true) or an end user (false). Defaults to false.
    """

    response_length: typing_extensions.Annotated[ResponseLength, FieldMetadata(alias="responseLength")] = (
        pydantic.Field()
    )
    """
    The desired response length. Defaults to ResponseLength.MEDIUM.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
