# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ...commons.types.attachment_request import AttachmentRequest
from ...commons.types.entity_id_base import EntityIdBase
from ...core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ...core.serialization import FieldMetadata


class AskRequest(UniversalBaseModel):
    """
    Examples
    --------
    from mavenagi.commons import AttachmentRequest, EntityIdBase
    from mavenagi.conversation import AskRequest

    AskRequest(
        conversation_message_id=EntityIdBase(
            reference_id="message-0",
        ),
        user_id=EntityIdBase(
            reference_id="user-0",
        ),
        text="How do I reset my password?",
        attachments=[
            AttachmentRequest(
                type="image/png",
                content="iVBORw0KGgo...",
            )
        ],
        transient_data={"userToken": "abcdef123", "queryApiKey": "foobar456"},
        timezone="America/New_York",
    )
    """

    conversation_message_id: typing_extensions.Annotated[EntityIdBase, FieldMetadata(alias="conversationMessageId")] = (
        pydantic.Field()
    )
    """
    Externally supplied ID to uniquely identify this message within the conversation. If a message with this ID already exists it will be reused and will not be updated.
    """

    user_id: typing_extensions.Annotated[EntityIdBase, FieldMetadata(alias="userId")] = pydantic.Field()
    """
    Externally supplied ID to uniquely identify the user that created this message
    """

    text: str = pydantic.Field()
    """
    The text of the message
    """

    attachments: typing.Optional[typing.List[AttachmentRequest]] = pydantic.Field(default=None)
    """
    The attachments to the message. Image attachments will be sent to the LLM as additional data.
    Non-image attachments can be stored and downloaded from the API but will not be sent to the LLM.
    """

    transient_data: typing_extensions.Annotated[
        typing.Optional[typing.Dict[str, str]], FieldMetadata(alias="transientData")
    ] = pydantic.Field(default=None)
    """
    Transient data which the Maven platform will not persist. This data will only be forwarded to actions taken by this ask request. For example, one may put in user tokens as transient data.
    """

    timezone: typing.Optional[str] = pydantic.Field(default=None)
    """
    IANA timezone identifier (e.g. "America/New_York", "Europe/London") to be used for time-based operations in the conversation.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
