# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
import typing_extensions
from ...commons.types.entity_id_filter import EntityIdFilter
from ...commons.types.feedback_type import FeedbackType
from ...commons.types.number_range import NumberRange
from ...commons.types.quality import Quality
from ...commons.types.quality_reason import QualityReason
from ...commons.types.response_length import ResponseLength
from ...commons.types.sentiment import Sentiment
from ...core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ...core.serialization import FieldMetadata
from .resolution_status import ResolutionStatus


class ConversationFilter(UniversalBaseModel):
    search: typing.Optional[str] = pydantic.Field(default=None)
    """
    Full-text search query for matching conversations by content. 
    When you search with this parameter, you're performing a full-text search across all textual content 
    in the conversations, including both the user's messages and the AI's responses.
    
    This field also supports a syntax for advanced filtering the `metadata` and `tags` fields.           
    
    Metadata examples:
    - `metadata:myvalue` - matches conversations with any metadata field set to `myvalue`
    - `metadata.mykey:myvalue` - matches conversations with a metadata field `mykey` set to `myvalue`
    - `metadata.mykey:myvalue OR anothervalue` - matches conversations with a metadata field `mykey` set to `myvalue` or `anothervalue`
    - `metadata.mykey:*` - matches conversations with a metadata field `mykey`
    - `-metadata:myvalue` - matches conversations that do not have any metadata field set to `myvalue`
    - `_exists_:metadata` - matches conversations that have any metadata field set
    
    Tags examples:
    - `tags:myvalue` - matches conversations with a tag of `myvalue`
    - `tags:myvalue OR anothervalue` - matches conversations with a tag of `myvalue` or `anothervalue`
    - `-tags:myvalue` - matches conversations that do not have the tag `myvalue`
    - `_exists_:tags` - matches conversations that have any tags field set
    """

    created_after: typing_extensions.Annotated[typing.Optional[dt.datetime], FieldMetadata(alias="createdAfter")] = (
        pydantic.Field(default=None)
    )
    """
    Filter conversations created on or after this timestamp
    """

    created_before: typing_extensions.Annotated[typing.Optional[dt.datetime], FieldMetadata(alias="createdBefore")] = (
        pydantic.Field(default=None)
    )
    """
    Filter conversations created on or before this timestamp
    """

    apps: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    Filter by app IDs
    """

    categories: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    Filter by conversation categories
    """

    actions: typing.Optional[typing.List[EntityIdFilter]] = pydantic.Field(default=None)
    """
    Filter by actions that were executed in the conversation
    """

    incomplete_actions: typing_extensions.Annotated[
        typing.Optional[typing.List[EntityIdFilter]], FieldMetadata(alias="incompleteActions")
    ] = pydantic.Field(default=None)
    """
    Filter by actions that were suggested but not completed by the AI agent
    """

    feedback: typing.Optional[typing.List[FeedbackType]] = pydantic.Field(default=None)
    """
    Filter by user feedback types received in the conversation
    """

    human_agents: typing_extensions.Annotated[typing.Optional[typing.List[str]], FieldMetadata(alias="humanAgents")] = (
        pydantic.Field(default=None)
    )
    """
    Filter by human agents who participated in the conversation
    """

    human_agents_with_inserts: typing_extensions.Annotated[
        typing.Optional[typing.List[str]], FieldMetadata(alias="humanAgentsWithInserts")
    ] = pydantic.Field(default=None)
    """
    Filter by human agents who inserted a maven AI generated suggestion in the conversation
    """

    languages: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    Filter by conversation languages
    """

    quality: typing.Optional[typing.List[Quality]] = pydantic.Field(default=None)
    """
    Filter by AI assessed conversation quality classification
    """

    quality_reason: typing_extensions.Annotated[
        typing.Optional[typing.List[QualityReason]], FieldMetadata(alias="qualityReason")
    ] = pydantic.Field(default=None)
    """
    Filter by AI assessed quality reason classification
    """

    response_length: typing_extensions.Annotated[
        typing.Optional[typing.List[ResponseLength]], FieldMetadata(alias="responseLength")
    ] = pydantic.Field(default=None)
    """
    Filter by AI response length classification
    """

    sentiment: typing.Optional[typing.List[Sentiment]] = pydantic.Field(default=None)
    """
    Filter by AI assessed sentiment analysis
    """

    tags: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    Filter by tags applied to the conversation
    """

    agent_user_ids: typing_extensions.Annotated[
        typing.Optional[typing.List[str]], FieldMetadata(alias="agentUserIds")
    ] = pydantic.Field(default=None)
    """
    Filter by agent user IDs associated with the conversation
    """

    resolution_status: typing_extensions.Annotated[
        typing.Optional[typing.List[ResolutionStatus]], FieldMetadata(alias="resolutionStatus")
    ] = pydantic.Field(default=None)
    """
    Filter by conversation resolution status which is determined by AI based on the conversation content.
    """

    resolved_by_maven: typing_extensions.Annotated[typing.Optional[bool], FieldMetadata(alias="resolvedByMaven")] = (
        pydantic.Field(default=None)
    )
    """
    Filter conversations based on whether they were resolved by Maven AI
    """

    user_message_count: typing_extensions.Annotated[
        typing.Optional[NumberRange], FieldMetadata(alias="userMessageCount")
    ] = pydantic.Field(default=None)
    """
    Filter by the number of messages sent by the user in the conversation
    """

    has_attachment: typing_extensions.Annotated[typing.Optional[bool], FieldMetadata(alias="hasAttachment")] = (
        pydantic.Field(default=None)
    )
    """
    Filter by whether any message in the conversation has an attachment
    """

    matched_segment_ids: typing_extensions.Annotated[
        typing.Optional[typing.List[EntityIdFilter]], FieldMetadata(alias="matchedSegmentIds")
    ] = pydantic.Field(default=None)
    """
    Filter by the segments that any message on a conversation matched.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
