# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ...commons.types.attachment_request import AttachmentRequest
from ...commons.types.entity_id_base import EntityIdBase
from ...commons.types.user_message_base import UserMessageBase
from ...core.pydantic_utilities import IS_PYDANTIC_V2
from ...core.serialization import FieldMetadata


class ConversationMessageRequest(UserMessageBase):
    conversation_message_id: typing_extensions.Annotated[EntityIdBase, FieldMetadata(alias="conversationMessageId")] = (
        pydantic.Field()
    )
    """
    The ID that uniquely identifies this message within the conversation
    """

    attachments: typing.Optional[typing.List[AttachmentRequest]] = pydantic.Field(default=None)
    """
    The attachments to the message.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
