# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ...commons.types.attachment_request import AttachmentRequest
from ...core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ...core.serialization import FieldMetadata


class ConversationPatchRequest(UniversalBaseModel):
    """
    Examples
    --------
    from mavenagi.conversation import ConversationPatchRequest

    ConversationPatchRequest(
        llm_enabled=True,
    )
    """

    app_id: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="appId")] = pydantic.Field(
        default=None
    )
    """
    The App ID of the conversation to patch. If not provided the ID of the calling app will be used.
    """

    open: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Whether the conversation is able to receive asynchronous messages. Only valid for conversations with the `ASYNC` capability.
    """

    llm_enabled: typing_extensions.Annotated[typing.Optional[bool], FieldMetadata(alias="llmEnabled")] = pydantic.Field(
        default=None
    )
    """
    Whether the LLM is enabled for this conversation.
    """

    attachments: typing.Optional[typing.List[AttachmentRequest]] = pydantic.Field(default=None)
    """
    A list of attachments to add to the conversation. Attachments can only be appended. Removal is not allowed.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
