# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
import typing_extensions
from ...commons.types.entity_id_base import EntityIdBase
from ...commons.types.response_config import ResponseConfig
from ...core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ...core.serialization import FieldMetadata
from .conversation_message_request import ConversationMessageRequest


class ConversationRequest(UniversalBaseModel):
    conversation_id: typing_extensions.Annotated[EntityIdBase, FieldMetadata(alias="conversationId")] = pydantic.Field()
    """
    An externally supplied ID to uniquely identify this conversation
    """

    response_config: typing_extensions.Annotated[
        typing.Optional[ResponseConfig], FieldMetadata(alias="responseConfig")
    ] = pydantic.Field(default=None)
    """
    Optional configurations for responses to this conversation
    """

    subject: typing.Optional[str] = pydantic.Field(default=None)
    """
    The subject of the conversation
    """

    url: typing.Optional[str] = pydantic.Field(default=None)
    """
    The url of the conversation
    """

    created_at: typing_extensions.Annotated[typing.Optional[dt.datetime], FieldMetadata(alias="createdAt")] = (
        pydantic.Field(default=None)
    )
    """
    The date and time the conversation was created
    """

    updated_at: typing_extensions.Annotated[typing.Optional[dt.datetime], FieldMetadata(alias="updatedAt")] = (
        pydantic.Field(default=None)
    )
    """
    The date and time the conversation was last updated
    """

    tags: typing.Optional[typing.Set[str]] = pydantic.Field(default=None)
    """
    The tags of the conversation. Used for filtering in Agent Designer.
    """

    metadata: typing.Optional[typing.Dict[str, str]] = pydantic.Field(default=None)
    """
    The metadata of the conversation supplied by the app which created the conversation.
    """

    messages: typing.List[ConversationMessageRequest] = pydantic.Field()
    """
    The messages in the conversation
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
