# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ...commons.types.entity_id_without_agent import EntityIdWithoutAgent
from ...core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ...core.serialization import FieldMetadata
from .conversation_message_request import ConversationMessageRequest


class DeliverConversationMessageRequest(UniversalBaseModel):
    conversation_id: typing_extensions.Annotated[EntityIdWithoutAgent, FieldMetadata(alias="conversationId")] = (
        pydantic.Field()
    )
    """
    The ID of the conversation to deliver the message to. Message delivery will fail if the conversation does not have the `ASYNC` capability or if it is not `open`.
    """

    message: ConversationMessageRequest = pydantic.Field()
    """
    The message to deliver.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
