# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ...commons.types.entity_id_base import EntityIdBase
from ...commons.types.feedback_base import FeedbackBase
from ...core.pydantic_utilities import IS_PYDANTIC_V2
from ...core.serialization import FieldMetadata


class FeedbackRequest(FeedbackBase):
    """
    Examples
    --------
    from mavenagi.commons import EntityIdBase
    from mavenagi.conversation import FeedbackRequest

    FeedbackRequest(
        feedback_id=EntityIdBase(
            reference_id="feedback-0",
        ),
        user_id=EntityIdBase(
            reference_id="user-0",
        ),
        conversation_id=EntityIdBase(
            reference_id="conversation-0",
        ),
        conversation_message_id=EntityIdBase(
            reference_id="message-1",
        ),
        type="THUMBS_UP",
        text="Great answer!",
    )
    """

    feedback_id: typing_extensions.Annotated[EntityIdBase, FieldMetadata(alias="feedbackId")] = pydantic.Field()
    """
    The ID that uniquely identifies this feedback
    """

    conversation_id: typing_extensions.Annotated[EntityIdBase, FieldMetadata(alias="conversationId")] = pydantic.Field()
    """
    The ID that uniquely identifies the the conversation the feedback is about
    """

    conversation_message_id: typing_extensions.Annotated[EntityIdBase, FieldMetadata(alias="conversationMessageId")] = (
        pydantic.Field()
    )
    """
    The ID that uniquely identifies the message within the conversation the feedback is about
    """

    user_id: typing_extensions.Annotated[typing.Optional[EntityIdBase], FieldMetadata(alias="userId")] = pydantic.Field(
        default=None
    )
    """
    The ID of the user who is creating the feedback
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
