# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import typing

import pydantic
import typing_extensions
from ...commons.types.entity_id import EntityId
from ...commons.types.error_message import ErrorMessage
from ...core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ...core.serialization import FieldMetadata


class ObjectStreamResponse_Text(UniversalBaseModel):
    event_type: typing_extensions.Annotated[typing.Literal["text"], FieldMetadata(alias="eventType")] = "text"
    contents: str

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


class ObjectStreamResponse_Start(UniversalBaseModel):
    event_type: typing_extensions.Annotated[typing.Literal["start"], FieldMetadata(alias="eventType")] = "start"
    conversation_message_id: typing_extensions.Annotated[EntityId, FieldMetadata(alias="conversationMessageId")]

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


class ObjectStreamResponse_End(UniversalBaseModel):
    event_type: typing_extensions.Annotated[typing.Literal["end"], FieldMetadata(alias="eventType")] = "end"
    error: typing.Optional[ErrorMessage] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


ObjectStreamResponse = typing.Union[ObjectStreamResponse_Text, ObjectStreamResponse_Start, ObjectStreamResponse_End]
