# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ...core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ...core.serialization import FieldMetadata


class UpdateMetadataRequest(UniversalBaseModel):
    """
    Examples
    --------
    from mavenagi.conversation import UpdateMetadataRequest

    UpdateMetadataRequest(
        app_id="conversation-owning-app",
        values={"key": "newValue"},
    )
    """

    app_id: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="appId")] = pydantic.Field(
        default=None
    )
    """
    The App ID of the conversation to modify metadata for. If not provided the ID of the calling app will be used.
    """

    values: typing.Dict[str, str] = pydantic.Field()
    """
    The metadata values to add to the conversation.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
