# This file was auto-generated by Fern from our API Definition.

import typing

from ..commons.types.event_field import EventField
from ..commons.types.event_filter import EventFilter
from ..commons.types.event_request import EventRequest
from ..commons.types.event_response import EventResponse
from ..commons.types.events_search_response import EventsSearchResponse
from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from .raw_client import AsyncRawEventsClient, RawEventsClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class EventsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawEventsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawEventsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawEventsClient
        """
        return self._raw_client

    def create(
        self, *, request: EventRequest, request_options: typing.Optional[RequestOptions] = None
    ) -> EventResponse:
        """
        Create a new event

        Parameters
        ----------
        request : EventRequest

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        EventResponse
            A response indicating the event was successfully accepted

        Examples
        --------
        from mavenagi import MavenAGI
        from mavenagi.commons import (
            EntityIdBase,
            EventRequest_UserEvent,
            EventUserInfoBase,
        )

        client = MavenAGI(
            organization_id="YOUR_ORGANIZATION_ID",
            agent_id="YOUR_AGENT_ID",
            app_id="YOUR_APP_ID",
            app_secret="YOUR_APP_SECRET",
        )
        client.events.create(
            request=EventRequest_UserEvent(
                id=EntityIdBase(
                    reference_id="referenceId",
                ),
                event_name="BUTTON_CLICKED",
                user_info=EventUserInfoBase(
                    id=EntityIdBase(
                        reference_id="referenceId",
                    ),
                ),
            ),
        )
        """
        _response = self._raw_client.create(request=request, request_options=request_options)
        return _response.data

    def search(
        self,
        *,
        sort: typing.Optional[EventField] = OMIT,
        filter: typing.Optional[EventFilter] = OMIT,
        page: typing.Optional[int] = OMIT,
        size: typing.Optional[int] = OMIT,
        sort_desc: typing.Optional[bool] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> EventsSearchResponse:
        """
        Search events

        Parameters
        ----------
        sort : typing.Optional[EventField]

        filter : typing.Optional[EventFilter]

        page : typing.Optional[int]
            Page number to return, defaults to 0

        size : typing.Optional[int]
            The size of the page to return, defaults to 20

        sort_desc : typing.Optional[bool]
            Whether to sort descending, defaults to true

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        EventsSearchResponse

        Examples
        --------
        from mavenagi import MavenAGI

        client = MavenAGI(
            organization_id="YOUR_ORGANIZATION_ID",
            agent_id="YOUR_AGENT_ID",
            app_id="YOUR_APP_ID",
            app_secret="YOUR_APP_SECRET",
        )
        client.events.search()
        """
        _response = self._raw_client.search(
            sort=sort, filter=filter, page=page, size=size, sort_desc=sort_desc, request_options=request_options
        )
        return _response.data


class AsyncEventsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawEventsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawEventsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawEventsClient
        """
        return self._raw_client

    async def create(
        self, *, request: EventRequest, request_options: typing.Optional[RequestOptions] = None
    ) -> EventResponse:
        """
        Create a new event

        Parameters
        ----------
        request : EventRequest

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        EventResponse
            A response indicating the event was successfully accepted

        Examples
        --------
        import asyncio

        from mavenagi import AsyncMavenAGI
        from mavenagi.commons import (
            EntityIdBase,
            EventRequest_UserEvent,
            EventUserInfoBase,
        )

        client = AsyncMavenAGI(
            organization_id="YOUR_ORGANIZATION_ID",
            agent_id="YOUR_AGENT_ID",
            app_id="YOUR_APP_ID",
            app_secret="YOUR_APP_SECRET",
        )


        async def main() -> None:
            await client.events.create(
                request=EventRequest_UserEvent(
                    id=EntityIdBase(
                        reference_id="referenceId",
                    ),
                    event_name="BUTTON_CLICKED",
                    user_info=EventUserInfoBase(
                        id=EntityIdBase(
                            reference_id="referenceId",
                        ),
                    ),
                ),
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create(request=request, request_options=request_options)
        return _response.data

    async def search(
        self,
        *,
        sort: typing.Optional[EventField] = OMIT,
        filter: typing.Optional[EventFilter] = OMIT,
        page: typing.Optional[int] = OMIT,
        size: typing.Optional[int] = OMIT,
        sort_desc: typing.Optional[bool] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> EventsSearchResponse:
        """
        Search events

        Parameters
        ----------
        sort : typing.Optional[EventField]

        filter : typing.Optional[EventFilter]

        page : typing.Optional[int]
            Page number to return, defaults to 0

        size : typing.Optional[int]
            The size of the page to return, defaults to 20

        sort_desc : typing.Optional[bool]
            Whether to sort descending, defaults to true

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        EventsSearchResponse

        Examples
        --------
        import asyncio

        from mavenagi import AsyncMavenAGI

        client = AsyncMavenAGI(
            organization_id="YOUR_ORGANIZATION_ID",
            agent_id="YOUR_AGENT_ID",
            app_id="YOUR_APP_ID",
            app_secret="YOUR_APP_SECRET",
        )


        async def main() -> None:
            await client.events.search()


        asyncio.run(main())
        """
        _response = await self._raw_client.search(
            sort=sort, filter=filter, page=page, size=size, sort_desc=sort_desc, request_options=request_options
        )
        return _response.data
