# This file was auto-generated by Fern from our API Definition.

import typing

from ..commons.types.inbox_item import InboxItem
from ..commons.types.inbox_item_fix import InboxItemFix
from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from .raw_client import AsyncRawInboxClient, RawInboxClient
from .types.add_document_fix_request import AddDocumentFixRequest
from .types.inbox_filter import InboxFilter
from .types.inbox_search_response import InboxSearchResponse

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class InboxClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawInboxClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawInboxClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawInboxClient
        """
        return self._raw_client

    def search(
        self,
        *,
        filter: typing.Optional[InboxFilter] = OMIT,
        page: typing.Optional[int] = OMIT,
        size: typing.Optional[int] = OMIT,
        sort_desc: typing.Optional[bool] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> InboxSearchResponse:
        """
        Retrieve a paginated list of inbox items for an agent.

        Parameters
        ----------
        filter : typing.Optional[InboxFilter]

        page : typing.Optional[int]
            Page number to return, defaults to 0

        size : typing.Optional[int]
            The size of the page to return, defaults to 20

        sort_desc : typing.Optional[bool]
            Whether to sort descending, defaults to true

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        InboxSearchResponse

        Examples
        --------
        from mavenagi import MavenAGI

        client = MavenAGI(
            organization_id="YOUR_ORGANIZATION_ID",
            agent_id="YOUR_AGENT_ID",
            app_id="YOUR_APP_ID",
            app_secret="YOUR_APP_SECRET",
        )
        client.inbox.search()
        """
        _response = self._raw_client.search(
            filter=filter, page=page, size=size, sort_desc=sort_desc, request_options=request_options
        )
        return _response.data

    def get(
        self, inbox_item_id: str, *, app_id: str, request_options: typing.Optional[RequestOptions] = None
    ) -> InboxItem:
        """
        Retrieve details of a specific inbox item by its ID.

        Parameters
        ----------
        inbox_item_id : str
            The ID of the inbox item to get. All other entity ID fields are inferred from the request.

        app_id : str
            The App ID of the inbox item to retrieve

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        InboxItem
            Details of the specified inbox item.

        Examples
        --------
        from mavenagi import MavenAGI

        client = MavenAGI(
            organization_id="YOUR_ORGANIZATION_ID",
            agent_id="YOUR_AGENT_ID",
            app_id="YOUR_APP_ID",
            app_secret="YOUR_APP_SECRET",
        )
        client.inbox.get(
            inbox_item_id="inboxItemId",
            app_id="appId",
        )
        """
        _response = self._raw_client.get(inbox_item_id, app_id=app_id, request_options=request_options)
        return _response.data

    def get_fix(
        self, inbox_item_fix_id: str, *, app_id: str, request_options: typing.Optional[RequestOptions] = None
    ) -> InboxItemFix:
        """
        Retrieve a suggested fix. Includes document information if the fix is a Missing Knowledge suggestion.

        Parameters
        ----------
        inbox_item_fix_id : str
            Unique identifier for the inbox fix.

        app_id : str
            The App ID of the inbox item fix to retrieve

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        InboxItemFix
            Details of the specified inbox item fix.

        Examples
        --------
        from mavenagi import MavenAGI

        client = MavenAGI(
            organization_id="YOUR_ORGANIZATION_ID",
            agent_id="YOUR_AGENT_ID",
            app_id="YOUR_APP_ID",
            app_secret="YOUR_APP_SECRET",
        )
        client.inbox.get_fix(
            inbox_item_fix_id="inboxItemFixId",
            app_id="appId",
        )
        """
        _response = self._raw_client.get_fix(inbox_item_fix_id, app_id=app_id, request_options=request_options)
        return _response.data

    def apply_fixes(
        self,
        inbox_item_id: str,
        *,
        app_id: str,
        fix_reference_ids: typing.Sequence[str],
        add_document_request: typing.Optional[AddDocumentFixRequest] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> None:
        """
        Apply a list of fixes belonging to an inbox item.

        Parameters
        ----------
        inbox_item_id : str
            Unique identifier for the inbox item.

        app_id : str
            The appId of the inbox item and fixes.

        fix_reference_ids : typing.Sequence[str]
            A list of one or more reference IDs of fixes to apply. All must belong to the same inbox item.

        add_document_request : typing.Optional[AddDocumentFixRequest]
            Only applies to add document fixes, includes the document content to save.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from mavenagi import MavenAGI

        client = MavenAGI(
            organization_id="YOUR_ORGANIZATION_ID",
            agent_id="YOUR_AGENT_ID",
            app_id="YOUR_APP_ID",
            app_secret="YOUR_APP_SECRET",
        )
        client.inbox.apply_fixes(
            inbox_item_id="inboxItemId",
            app_id="appId",
            fix_reference_ids=["fixReferenceIds", "fixReferenceIds"],
        )
        """
        _response = self._raw_client.apply_fixes(
            inbox_item_id,
            app_id=app_id,
            fix_reference_ids=fix_reference_ids,
            add_document_request=add_document_request,
            request_options=request_options,
        )
        return _response.data

    def ignore(
        self, inbox_item_id: str, *, app_id: str, request_options: typing.Optional[RequestOptions] = None
    ) -> None:
        """
        Ignore a specific inbox item by its ID.

        Parameters
        ----------
        inbox_item_id : str
            Unique identifier for the inbox item.

        app_id : str
            The App ID of the inbox item fix to ignore

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from mavenagi import MavenAGI

        client = MavenAGI(
            organization_id="YOUR_ORGANIZATION_ID",
            agent_id="YOUR_AGENT_ID",
            app_id="YOUR_APP_ID",
            app_secret="YOUR_APP_SECRET",
        )
        client.inbox.ignore(
            inbox_item_id="inboxItemId",
            app_id="appId",
        )
        """
        _response = self._raw_client.ignore(inbox_item_id, app_id=app_id, request_options=request_options)
        return _response.data


class AsyncInboxClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawInboxClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawInboxClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawInboxClient
        """
        return self._raw_client

    async def search(
        self,
        *,
        filter: typing.Optional[InboxFilter] = OMIT,
        page: typing.Optional[int] = OMIT,
        size: typing.Optional[int] = OMIT,
        sort_desc: typing.Optional[bool] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> InboxSearchResponse:
        """
        Retrieve a paginated list of inbox items for an agent.

        Parameters
        ----------
        filter : typing.Optional[InboxFilter]

        page : typing.Optional[int]
            Page number to return, defaults to 0

        size : typing.Optional[int]
            The size of the page to return, defaults to 20

        sort_desc : typing.Optional[bool]
            Whether to sort descending, defaults to true

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        InboxSearchResponse

        Examples
        --------
        import asyncio

        from mavenagi import AsyncMavenAGI

        client = AsyncMavenAGI(
            organization_id="YOUR_ORGANIZATION_ID",
            agent_id="YOUR_AGENT_ID",
            app_id="YOUR_APP_ID",
            app_secret="YOUR_APP_SECRET",
        )


        async def main() -> None:
            await client.inbox.search()


        asyncio.run(main())
        """
        _response = await self._raw_client.search(
            filter=filter, page=page, size=size, sort_desc=sort_desc, request_options=request_options
        )
        return _response.data

    async def get(
        self, inbox_item_id: str, *, app_id: str, request_options: typing.Optional[RequestOptions] = None
    ) -> InboxItem:
        """
        Retrieve details of a specific inbox item by its ID.

        Parameters
        ----------
        inbox_item_id : str
            The ID of the inbox item to get. All other entity ID fields are inferred from the request.

        app_id : str
            The App ID of the inbox item to retrieve

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        InboxItem
            Details of the specified inbox item.

        Examples
        --------
        import asyncio

        from mavenagi import AsyncMavenAGI

        client = AsyncMavenAGI(
            organization_id="YOUR_ORGANIZATION_ID",
            agent_id="YOUR_AGENT_ID",
            app_id="YOUR_APP_ID",
            app_secret="YOUR_APP_SECRET",
        )


        async def main() -> None:
            await client.inbox.get(
                inbox_item_id="inboxItemId",
                app_id="appId",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get(inbox_item_id, app_id=app_id, request_options=request_options)
        return _response.data

    async def get_fix(
        self, inbox_item_fix_id: str, *, app_id: str, request_options: typing.Optional[RequestOptions] = None
    ) -> InboxItemFix:
        """
        Retrieve a suggested fix. Includes document information if the fix is a Missing Knowledge suggestion.

        Parameters
        ----------
        inbox_item_fix_id : str
            Unique identifier for the inbox fix.

        app_id : str
            The App ID of the inbox item fix to retrieve

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        InboxItemFix
            Details of the specified inbox item fix.

        Examples
        --------
        import asyncio

        from mavenagi import AsyncMavenAGI

        client = AsyncMavenAGI(
            organization_id="YOUR_ORGANIZATION_ID",
            agent_id="YOUR_AGENT_ID",
            app_id="YOUR_APP_ID",
            app_secret="YOUR_APP_SECRET",
        )


        async def main() -> None:
            await client.inbox.get_fix(
                inbox_item_fix_id="inboxItemFixId",
                app_id="appId",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get_fix(inbox_item_fix_id, app_id=app_id, request_options=request_options)
        return _response.data

    async def apply_fixes(
        self,
        inbox_item_id: str,
        *,
        app_id: str,
        fix_reference_ids: typing.Sequence[str],
        add_document_request: typing.Optional[AddDocumentFixRequest] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> None:
        """
        Apply a list of fixes belonging to an inbox item.

        Parameters
        ----------
        inbox_item_id : str
            Unique identifier for the inbox item.

        app_id : str
            The appId of the inbox item and fixes.

        fix_reference_ids : typing.Sequence[str]
            A list of one or more reference IDs of fixes to apply. All must belong to the same inbox item.

        add_document_request : typing.Optional[AddDocumentFixRequest]
            Only applies to add document fixes, includes the document content to save.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        import asyncio

        from mavenagi import AsyncMavenAGI

        client = AsyncMavenAGI(
            organization_id="YOUR_ORGANIZATION_ID",
            agent_id="YOUR_AGENT_ID",
            app_id="YOUR_APP_ID",
            app_secret="YOUR_APP_SECRET",
        )


        async def main() -> None:
            await client.inbox.apply_fixes(
                inbox_item_id="inboxItemId",
                app_id="appId",
                fix_reference_ids=["fixReferenceIds", "fixReferenceIds"],
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.apply_fixes(
            inbox_item_id,
            app_id=app_id,
            fix_reference_ids=fix_reference_ids,
            add_document_request=add_document_request,
            request_options=request_options,
        )
        return _response.data

    async def ignore(
        self, inbox_item_id: str, *, app_id: str, request_options: typing.Optional[RequestOptions] = None
    ) -> None:
        """
        Ignore a specific inbox item by its ID.

        Parameters
        ----------
        inbox_item_id : str
            Unique identifier for the inbox item.

        app_id : str
            The App ID of the inbox item fix to ignore

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        import asyncio

        from mavenagi import AsyncMavenAGI

        client = AsyncMavenAGI(
            organization_id="YOUR_ORGANIZATION_ID",
            agent_id="YOUR_AGENT_ID",
            app_id="YOUR_APP_ID",
            app_secret="YOUR_APP_SECRET",
        )


        async def main() -> None:
            await client.inbox.ignore(
                inbox_item_id="inboxItemId",
                app_id="appId",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.ignore(inbox_item_id, app_id=app_id, request_options=request_options)
        return _response.data
