# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ...core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ...core.serialization import FieldMetadata
from ...knowledge.types.knowledge_document_request import KnowledgeDocumentRequest


class AddDocumentFixRequest(UniversalBaseModel):
    knowledge_document_request: typing_extensions.Annotated[
        KnowledgeDocumentRequest, FieldMetadata(alias="knowledgeDocumentRequest")
    ] = pydantic.Field()
    """
    Knowledge document to be added by this request
    """

    knowledge_base_reference_id: typing_extensions.Annotated[str, FieldMetadata(alias="knowledgeBaseReferenceId")] = (
        pydantic.Field()
    )
    """
    Reference id of the Knowledge Base the document will be added to. 
    The appId is inferred from the request. Apps can only add documents to their own knowledge bases.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
