# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ...core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ...core.serialization import FieldMetadata
from .add_document_fix_request import AddDocumentFixRequest


class ApplyFixesRequest(UniversalBaseModel):
    app_id: typing_extensions.Annotated[str, FieldMetadata(alias="appId")] = pydantic.Field()
    """
    The appId of the inbox item and fixes.
    """

    fix_reference_ids: typing_extensions.Annotated[typing.List[str], FieldMetadata(alias="fixReferenceIds")] = (
        pydantic.Field()
    )
    """
    A list of one or more reference IDs of fixes to apply. All must belong to the same inbox item.
    """

    add_document_request: typing_extensions.Annotated[
        typing.Optional[AddDocumentFixRequest], FieldMetadata(alias="addDocumentRequest")
    ] = pydantic.Field(default=None)
    """
    Only applies to add document fixes, includes the document content to save.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
