# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
import typing_extensions
from ...commons.types.inbox_item_status import InboxItemStatus
from ...commons.types.inbox_item_type import InboxItemType
from ...core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ...core.serialization import FieldMetadata


class InboxFilter(UniversalBaseModel):
    statuses: typing.Optional[typing.List[InboxItemStatus]] = pydantic.Field(default=None)
    """
    List of inbox item statuses to filter by.
    """

    type: typing.Optional[typing.List[InboxItemType]] = pydantic.Field(default=None)
    """
    List of inbox item types to filter by.
    """

    created_after: typing_extensions.Annotated[typing.Optional[dt.datetime], FieldMetadata(alias="createdAfter")] = (
        pydantic.Field(default=None)
    )
    """
    Filter for items created after this timestamp.
    """

    created_before: typing_extensions.Annotated[typing.Optional[dt.datetime], FieldMetadata(alias="createdBefore")] = (
        pydantic.Field(default=None)
    )
    """
    Filter for items created before this timestamp.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
