# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ..commons.types.entity_id import EntityId
from ..commons.types.entity_id_base import EntityIdBase
from ..commons.types.entity_id_without_agent import EntityIdWithoutAgent
from ..commons.types.llm_inclusion_status import LlmInclusionStatus
from ..commons.types.precondition import Precondition
from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from .raw_client import AsyncRawKnowledgeClient, RawKnowledgeClient
from .types.knowledge_base_field import KnowledgeBaseField
from .types.knowledge_base_filter import KnowledgeBaseFilter
from .types.knowledge_base_refresh_frequency import KnowledgeBaseRefreshFrequency
from .types.knowledge_base_response import KnowledgeBaseResponse
from .types.knowledge_base_version import KnowledgeBaseVersion
from .types.knowledge_base_version_finalize_status import KnowledgeBaseVersionFinalizeStatus
from .types.knowledge_base_version_type import KnowledgeBaseVersionType
from .types.knowledge_base_versions_list_response import KnowledgeBaseVersionsListResponse
from .types.knowledge_bases_response import KnowledgeBasesResponse
from .types.knowledge_document_content_type import KnowledgeDocumentContentType
from .types.knowledge_document_field import KnowledgeDocumentField
from .types.knowledge_document_filter import KnowledgeDocumentFilter
from .types.knowledge_document_response import KnowledgeDocumentResponse
from .types.knowledge_documents_response import KnowledgeDocumentsResponse

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class KnowledgeClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawKnowledgeClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawKnowledgeClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawKnowledgeClient
        """
        return self._raw_client

    def search_knowledge_bases(
        self,
        *,
        sort: typing.Optional[KnowledgeBaseField] = OMIT,
        filter: typing.Optional[KnowledgeBaseFilter] = OMIT,
        page: typing.Optional[int] = OMIT,
        size: typing.Optional[int] = OMIT,
        sort_desc: typing.Optional[bool] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> KnowledgeBasesResponse:
        """
        Search knowledge bases

        Parameters
        ----------
        sort : typing.Optional[KnowledgeBaseField]

        filter : typing.Optional[KnowledgeBaseFilter]

        page : typing.Optional[int]
            Page number to return, defaults to 0

        size : typing.Optional[int]
            The size of the page to return, defaults to 20

        sort_desc : typing.Optional[bool]
            Whether to sort descending, defaults to true

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        KnowledgeBasesResponse

        Examples
        --------
        from mavenagi import MavenAGI

        client = MavenAGI(
            organization_id="YOUR_ORGANIZATION_ID",
            agent_id="YOUR_AGENT_ID",
            app_id="YOUR_APP_ID",
            app_secret="YOUR_APP_SECRET",
        )
        client.knowledge.search_knowledge_bases()
        """
        _response = self._raw_client.search_knowledge_bases(
            sort=sort, filter=filter, page=page, size=size, sort_desc=sort_desc, request_options=request_options
        )
        return _response.data

    def create_or_update_knowledge_base(
        self,
        *,
        knowledge_base_id: EntityIdBase,
        name: str,
        metadata: typing.Optional[typing.Dict[str, str]] = OMIT,
        precondition: typing.Optional[Precondition] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> KnowledgeBaseResponse:
        """
        Update a knowledge base or create it if it doesn't exist.

        Parameters
        ----------
        knowledge_base_id : EntityIdBase
            ID that uniquely identifies this knowledge base

        name : str
            The name of the knowledge base

        metadata : typing.Optional[typing.Dict[str, str]]
            Metadata for the knowledge base.

        precondition : typing.Optional[Precondition]
            The preconditions that must be met for knowledge base be relevant to a conversation. Can be used to restrict knowledge bases to certain types of users.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        KnowledgeBaseResponse

        Examples
        --------
        from mavenagi import MavenAGI
        from mavenagi.commons import EntityIdBase

        client = MavenAGI(
            organization_id="YOUR_ORGANIZATION_ID",
            agent_id="YOUR_AGENT_ID",
            app_id="YOUR_APP_ID",
            app_secret="YOUR_APP_SECRET",
        )
        client.knowledge.create_or_update_knowledge_base(
            knowledge_base_id=EntityIdBase(
                reference_id="help-center",
            ),
            name="Help center",
        )
        """
        _response = self._raw_client.create_or_update_knowledge_base(
            knowledge_base_id=knowledge_base_id,
            name=name,
            metadata=metadata,
            precondition=precondition,
            request_options=request_options,
        )
        return _response.data

    def get_knowledge_base(
        self,
        knowledge_base_reference_id: str,
        *,
        app_id: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> KnowledgeBaseResponse:
        """
        Get an existing knowledge base by its supplied ID

        Parameters
        ----------
        knowledge_base_reference_id : str
            The reference ID of the knowledge base to get. All other entity ID fields are inferred from the request.

        app_id : typing.Optional[str]
            The App ID of the knowledge base to get. If not provided the ID of the calling app will be used.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        KnowledgeBaseResponse

        Examples
        --------
        from mavenagi import MavenAGI

        client = MavenAGI(
            organization_id="YOUR_ORGANIZATION_ID",
            agent_id="YOUR_AGENT_ID",
            app_id="YOUR_APP_ID",
            app_secret="YOUR_APP_SECRET",
        )
        client.knowledge.get_knowledge_base(
            knowledge_base_reference_id="help-center",
        )
        """
        _response = self._raw_client.get_knowledge_base(
            knowledge_base_reference_id, app_id=app_id, request_options=request_options
        )
        return _response.data

    def patch_knowledge_base(
        self,
        knowledge_base_reference_id: str,
        *,
        app_id: typing.Optional[str] = OMIT,
        name: typing.Optional[str] = OMIT,
        tags: typing.Optional[typing.Set[str]] = OMIT,
        llm_inclusion_status: typing.Optional[LlmInclusionStatus] = OMIT,
        precondition: typing.Optional[Precondition] = OMIT,
        segment_id: typing.Optional[EntityId] = OMIT,
        refresh_frequency: typing.Optional[KnowledgeBaseRefreshFrequency] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> KnowledgeBaseResponse:
        """
        Update mutable knowledge base fields

        The `appId` field can be provided to update a knowledge base owned by a different app.
        All other fields will overwrite the existing value on the knowledge base only if provided.

        Parameters
        ----------
        knowledge_base_reference_id : str
            The reference ID of the knowledge base to patch.

        app_id : typing.Optional[str]
            The App ID of the knowledge base to patch. If not provided the ID of the calling app will be used.

        name : typing.Optional[str]
            The name of the knowledge base.

        tags : typing.Optional[typing.Set[str]]
            The tags of the knowledge base.

        llm_inclusion_status : typing.Optional[LlmInclusionStatus]
            Determines whether documents in the knowledge base are sent to the LLM as part of a conversation. Note that at this time knowledge bases can not be set to `ALWAYS`.

        precondition : typing.Optional[Precondition]
            The preconditions that must be met for a knowledge base to be relevant to a conversation. Can be used to restrict knowledge bases to certain types of users. A null value will remove the precondition from the knowledge base, it will be available on all conversations.

        segment_id : typing.Optional[EntityId]
            The ID of the segment that must be matched for the knowledge base to be relevant to a conversation.
            A null value will remove the segment from the knowledge base, it will be available on all conversations.

            Segments are replacing inline preconditions - a knowledge base may not have both an inline precondition and a segment.
            Inline precondition support will be removed in a future release.

        refresh_frequency : typing.Optional[KnowledgeBaseRefreshFrequency]
            How often the knowledge base should be refreshed.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        KnowledgeBaseResponse

        Examples
        --------
        from mavenagi import MavenAGI

        client = MavenAGI(
            organization_id="YOUR_ORGANIZATION_ID",
            agent_id="YOUR_AGENT_ID",
            app_id="YOUR_APP_ID",
            app_secret="YOUR_APP_SECRET",
        )
        client.knowledge.patch_knowledge_base(
            knowledge_base_reference_id="knowledgeBaseReferenceId",
        )
        """
        _response = self._raw_client.patch_knowledge_base(
            knowledge_base_reference_id,
            app_id=app_id,
            name=name,
            tags=tags,
            llm_inclusion_status=llm_inclusion_status,
            precondition=precondition,
            segment_id=segment_id,
            refresh_frequency=refresh_frequency,
            request_options=request_options,
        )
        return _response.data

    def create_knowledge_base_version(
        self,
        knowledge_base_reference_id: str,
        *,
        type: KnowledgeBaseVersionType,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> KnowledgeBaseVersion:
        """
        Create a new knowledge base version.

        If an existing version is in progress, then that version will be finalized in an error state.

        Parameters
        ----------
        knowledge_base_reference_id : str
            The reference ID of the knowledge base to create a version for. All other entity ID fields are inferred from the request.

        type : KnowledgeBaseVersionType
            Indicates whether the completed version constitutes a full or partial refresh of the knowledge base. Deleting and updating documents is only supported for partial refreshes.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        KnowledgeBaseVersion

        Examples
        --------
        from mavenagi import MavenAGI

        client = MavenAGI(
            organization_id="YOUR_ORGANIZATION_ID",
            agent_id="YOUR_AGENT_ID",
            app_id="YOUR_APP_ID",
            app_secret="YOUR_APP_SECRET",
        )
        client.knowledge.create_knowledge_base_version(
            knowledge_base_reference_id="help-center",
            type="FULL",
        )
        """
        _response = self._raw_client.create_knowledge_base_version(
            knowledge_base_reference_id, type=type, request_options=request_options
        )
        return _response.data

    def finalize_knowledge_base_version(
        self,
        knowledge_base_reference_id: str,
        *,
        version_id: typing.Optional[EntityIdWithoutAgent] = OMIT,
        status: typing.Optional[KnowledgeBaseVersionFinalizeStatus] = OMIT,
        error_message: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> KnowledgeBaseVersion:
        """
        Finalize the latest knowledge base version. Required to indicate the version is complete. Will throw an exception if the latest version is not in progress.

        Parameters
        ----------
        knowledge_base_reference_id : str
            The reference ID of the knowledge base to finalize a version for. All other entity ID fields are inferred from the request.

        version_id : typing.Optional[EntityIdWithoutAgent]
            ID that uniquely identifies which knowledge base version to finalize. If not provided will use the most recent version of the knowledge base.

        status : typing.Optional[KnowledgeBaseVersionFinalizeStatus]
            Whether the knowledge base version processing was successful or not.

        error_message : typing.Optional[str]
            A user-facing error message that provides more details about a version failure.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        KnowledgeBaseVersion

        Examples
        --------
        from mavenagi import MavenAGI
        from mavenagi.commons import EntityIdWithoutAgent

        client = MavenAGI(
            organization_id="YOUR_ORGANIZATION_ID",
            agent_id="YOUR_AGENT_ID",
            app_id="YOUR_APP_ID",
            app_secret="YOUR_APP_SECRET",
        )
        client.knowledge.finalize_knowledge_base_version(
            knowledge_base_reference_id="help-center",
            version_id=EntityIdWithoutAgent(
                type="KNOWLEDGE_BASE_VERSION",
                reference_id="versionId",
                app_id="maven",
            ),
            status="SUCCEEDED",
        )
        """
        _response = self._raw_client.finalize_knowledge_base_version(
            knowledge_base_reference_id,
            version_id=version_id,
            status=status,
            error_message=error_message,
            request_options=request_options,
        )
        return _response.data

    def list_knowledge_base_versions(
        self,
        knowledge_base_reference_id: str,
        *,
        app_id: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> KnowledgeBaseVersionsListResponse:
        """
        List all active versions for a knowledge base. Returns the most recent versions first.

        Parameters
        ----------
        knowledge_base_reference_id : str
            The reference ID of the knowledge base to list versions for. All other entity ID fields are inferred from the request.

        app_id : typing.Optional[str]
            The App ID of the knowledge base. If not provided the ID of the calling app will be used.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        KnowledgeBaseVersionsListResponse

        Examples
        --------
        from mavenagi import MavenAGI

        client = MavenAGI(
            organization_id="YOUR_ORGANIZATION_ID",
            agent_id="YOUR_AGENT_ID",
            app_id="YOUR_APP_ID",
            app_secret="YOUR_APP_SECRET",
        )
        client.knowledge.list_knowledge_base_versions(
            knowledge_base_reference_id="knowledgeBaseReferenceId",
        )
        """
        _response = self._raw_client.list_knowledge_base_versions(
            knowledge_base_reference_id, app_id=app_id, request_options=request_options
        )
        return _response.data

    def search_knowledge_documents(
        self,
        *,
        sort: typing.Optional[KnowledgeDocumentField] = OMIT,
        filter: typing.Optional[KnowledgeDocumentFilter] = OMIT,
        page: typing.Optional[int] = OMIT,
        size: typing.Optional[int] = OMIT,
        sort_desc: typing.Optional[bool] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> KnowledgeDocumentsResponse:
        """
        Search knowledge documents

        Parameters
        ----------
        sort : typing.Optional[KnowledgeDocumentField]

        filter : typing.Optional[KnowledgeDocumentFilter]

        page : typing.Optional[int]
            Page number to return, defaults to 0

        size : typing.Optional[int]
            The size of the page to return, defaults to 20

        sort_desc : typing.Optional[bool]
            Whether to sort descending, defaults to true

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        KnowledgeDocumentsResponse

        Examples
        --------
        from mavenagi import MavenAGI

        client = MavenAGI(
            organization_id="YOUR_ORGANIZATION_ID",
            agent_id="YOUR_AGENT_ID",
            app_id="YOUR_APP_ID",
            app_secret="YOUR_APP_SECRET",
        )
        client.knowledge.search_knowledge_documents()
        """
        _response = self._raw_client.search_knowledge_documents(
            sort=sort, filter=filter, page=page, size=size, sort_desc=sort_desc, request_options=request_options
        )
        return _response.data

    def create_knowledge_document(
        self,
        knowledge_base_reference_id: str,
        *,
        knowledge_document_id: EntityIdBase,
        content_type: KnowledgeDocumentContentType,
        content: str,
        title: str,
        version_id: typing.Optional[EntityIdWithoutAgent] = OMIT,
        metadata: typing.Optional[typing.Dict[str, str]] = OMIT,
        url: typing.Optional[str] = OMIT,
        language: typing.Optional[str] = OMIT,
        created_at: typing.Optional[dt.datetime] = OMIT,
        updated_at: typing.Optional[dt.datetime] = OMIT,
        author: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> KnowledgeDocumentResponse:
        """
        Create or update a knowledge document. Requires an existing knowledge base with an in progress version.
        Will throw an exception if the latest version is not in progress.

        <Tip>
        This API maintains document version history. If for the same reference ID none of the `title`, `text`, `sourceUrl`, `metadata` fields
        have changed, a new document version will not be created. The existing version will be reused.
        </Tip>

        Parameters
        ----------
        knowledge_base_reference_id : str
            The reference ID of the knowledge base to create a document for. All other entity ID fields are inferred from the request.

        knowledge_document_id : EntityIdBase
            ID that uniquely identifies this knowledge document within its knowledge base

        content_type : KnowledgeDocumentContentType

        content : str
            The content of the document. Not shown directly to users. May be provided in HTML or markdown. HTML will be converted to markdown automatically. Images are not currently supported and will be ignored.

        title : str
            The title of the document. Will be shown as part of answers.

        version_id : typing.Optional[EntityIdWithoutAgent]
            ID that uniquely identifies which knowledge base version to create the document in. If not provided will use the most recent version of the knowledge base.

        metadata : typing.Optional[typing.Dict[str, str]]
            Metadata for the knowledge document.

        url : typing.Optional[str]
            The URL of the document. Should be visible to end users. Will be shown as part of answers. Not used for crawling.

        language : typing.Optional[str]
            The document language. Must be a valid ISO 639-1 language code.

        created_at : typing.Optional[dt.datetime]
            The time at which this document was created.

        updated_at : typing.Optional[dt.datetime]
            The time at which this document was last modified.

        author : typing.Optional[str]
            The name of the author who created this document.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        KnowledgeDocumentResponse

        Examples
        --------
        from mavenagi import MavenAGI
        from mavenagi.commons import EntityIdBase, EntityIdWithoutAgent

        client = MavenAGI(
            organization_id="YOUR_ORGANIZATION_ID",
            agent_id="YOUR_AGENT_ID",
            app_id="YOUR_APP_ID",
            app_secret="YOUR_APP_SECRET",
        )
        client.knowledge.create_knowledge_document(
            knowledge_base_reference_id="help-center",
            knowledge_document_id=EntityIdBase(
                reference_id="getting-started",
            ),
            version_id=EntityIdWithoutAgent(
                type="KNOWLEDGE_BASE_VERSION",
                reference_id="versionId",
                app_id="maven",
            ),
            content_type="MARKDOWN",
            content="## Getting started\\nThis is a getting started guide for the help center.",
            title="Getting started",
            metadata={"category": "getting-started"},
        )
        """
        _response = self._raw_client.create_knowledge_document(
            knowledge_base_reference_id,
            knowledge_document_id=knowledge_document_id,
            content_type=content_type,
            content=content,
            title=title,
            version_id=version_id,
            metadata=metadata,
            url=url,
            language=language,
            created_at=created_at,
            updated_at=updated_at,
            author=author,
            request_options=request_options,
        )
        return _response.data

    def delete_knowledge_document(
        self,
        knowledge_base_reference_id: str,
        knowledge_document_reference_id: str,
        *,
        version_id: EntityIdWithoutAgent,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> None:
        """
        Delete knowledge document from a specific version.
        Requires an existing knowledge base with an in progress version of type PARTIAL. Will throw an exception if the version is not in progress.

        Parameters
        ----------
        knowledge_base_reference_id : str
            The reference ID of the knowledge base that contains the document to delete. All other entity ID fields are inferred from the request

        knowledge_document_reference_id : str
            The reference ID of the knowledge document to delete. All other entity ID fields are inferred from the request.

        version_id : EntityIdWithoutAgent
            ID that uniquely identifies which knowledge base version to delete the document from.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from mavenagi import MavenAGI
        from mavenagi.commons import EntityIdWithoutAgent

        client = MavenAGI(
            organization_id="YOUR_ORGANIZATION_ID",
            agent_id="YOUR_AGENT_ID",
            app_id="YOUR_APP_ID",
            app_secret="YOUR_APP_SECRET",
        )
        client.knowledge.delete_knowledge_document(
            knowledge_base_reference_id="help-center",
            knowledge_document_reference_id="getting-started",
            version_id=EntityIdWithoutAgent(
                type="KNOWLEDGE_BASE_VERSION",
                app_id="maven",
                reference_id="versionId",
            ),
        )
        """
        _response = self._raw_client.delete_knowledge_document(
            knowledge_base_reference_id,
            knowledge_document_reference_id,
            version_id=version_id,
            request_options=request_options,
        )
        return _response.data

    def get_knowledge_document(
        self,
        knowledge_base_version_reference_id: str,
        knowledge_document_reference_id: str,
        *,
        knowledge_base_version_app_id: str,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> KnowledgeDocumentResponse:
        """
        Get a knowledge document by its supplied version and document IDs. Response includes document content in markdown format.

        Parameters
        ----------
        knowledge_base_version_reference_id : str
            The reference ID of the knowledge base version that contains the document. All other entity ID fields are inferred from the request.

        knowledge_document_reference_id : str
            The reference ID of the knowledge document to get. All other entity ID fields are inferred from the request.

        knowledge_base_version_app_id : str
            The App ID of the knowledge base version.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        KnowledgeDocumentResponse

        Examples
        --------
        from mavenagi import MavenAGI

        client = MavenAGI(
            organization_id="YOUR_ORGANIZATION_ID",
            agent_id="YOUR_AGENT_ID",
            app_id="YOUR_APP_ID",
            app_secret="YOUR_APP_SECRET",
        )
        client.knowledge.get_knowledge_document(
            knowledge_base_version_reference_id="knowledgeBaseVersionReferenceId",
            knowledge_document_reference_id="knowledgeDocumentReferenceId",
            knowledge_base_version_app_id="knowledgeBaseVersionAppId",
        )
        """
        _response = self._raw_client.get_knowledge_document(
            knowledge_base_version_reference_id,
            knowledge_document_reference_id,
            knowledge_base_version_app_id=knowledge_base_version_app_id,
            request_options=request_options,
        )
        return _response.data


class AsyncKnowledgeClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawKnowledgeClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawKnowledgeClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawKnowledgeClient
        """
        return self._raw_client

    async def search_knowledge_bases(
        self,
        *,
        sort: typing.Optional[KnowledgeBaseField] = OMIT,
        filter: typing.Optional[KnowledgeBaseFilter] = OMIT,
        page: typing.Optional[int] = OMIT,
        size: typing.Optional[int] = OMIT,
        sort_desc: typing.Optional[bool] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> KnowledgeBasesResponse:
        """
        Search knowledge bases

        Parameters
        ----------
        sort : typing.Optional[KnowledgeBaseField]

        filter : typing.Optional[KnowledgeBaseFilter]

        page : typing.Optional[int]
            Page number to return, defaults to 0

        size : typing.Optional[int]
            The size of the page to return, defaults to 20

        sort_desc : typing.Optional[bool]
            Whether to sort descending, defaults to true

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        KnowledgeBasesResponse

        Examples
        --------
        import asyncio

        from mavenagi import AsyncMavenAGI

        client = AsyncMavenAGI(
            organization_id="YOUR_ORGANIZATION_ID",
            agent_id="YOUR_AGENT_ID",
            app_id="YOUR_APP_ID",
            app_secret="YOUR_APP_SECRET",
        )


        async def main() -> None:
            await client.knowledge.search_knowledge_bases()


        asyncio.run(main())
        """
        _response = await self._raw_client.search_knowledge_bases(
            sort=sort, filter=filter, page=page, size=size, sort_desc=sort_desc, request_options=request_options
        )
        return _response.data

    async def create_or_update_knowledge_base(
        self,
        *,
        knowledge_base_id: EntityIdBase,
        name: str,
        metadata: typing.Optional[typing.Dict[str, str]] = OMIT,
        precondition: typing.Optional[Precondition] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> KnowledgeBaseResponse:
        """
        Update a knowledge base or create it if it doesn't exist.

        Parameters
        ----------
        knowledge_base_id : EntityIdBase
            ID that uniquely identifies this knowledge base

        name : str
            The name of the knowledge base

        metadata : typing.Optional[typing.Dict[str, str]]
            Metadata for the knowledge base.

        precondition : typing.Optional[Precondition]
            The preconditions that must be met for knowledge base be relevant to a conversation. Can be used to restrict knowledge bases to certain types of users.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        KnowledgeBaseResponse

        Examples
        --------
        import asyncio

        from mavenagi import AsyncMavenAGI
        from mavenagi.commons import EntityIdBase

        client = AsyncMavenAGI(
            organization_id="YOUR_ORGANIZATION_ID",
            agent_id="YOUR_AGENT_ID",
            app_id="YOUR_APP_ID",
            app_secret="YOUR_APP_SECRET",
        )


        async def main() -> None:
            await client.knowledge.create_or_update_knowledge_base(
                knowledge_base_id=EntityIdBase(
                    reference_id="help-center",
                ),
                name="Help center",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create_or_update_knowledge_base(
            knowledge_base_id=knowledge_base_id,
            name=name,
            metadata=metadata,
            precondition=precondition,
            request_options=request_options,
        )
        return _response.data

    async def get_knowledge_base(
        self,
        knowledge_base_reference_id: str,
        *,
        app_id: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> KnowledgeBaseResponse:
        """
        Get an existing knowledge base by its supplied ID

        Parameters
        ----------
        knowledge_base_reference_id : str
            The reference ID of the knowledge base to get. All other entity ID fields are inferred from the request.

        app_id : typing.Optional[str]
            The App ID of the knowledge base to get. If not provided the ID of the calling app will be used.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        KnowledgeBaseResponse

        Examples
        --------
        import asyncio

        from mavenagi import AsyncMavenAGI

        client = AsyncMavenAGI(
            organization_id="YOUR_ORGANIZATION_ID",
            agent_id="YOUR_AGENT_ID",
            app_id="YOUR_APP_ID",
            app_secret="YOUR_APP_SECRET",
        )


        async def main() -> None:
            await client.knowledge.get_knowledge_base(
                knowledge_base_reference_id="help-center",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get_knowledge_base(
            knowledge_base_reference_id, app_id=app_id, request_options=request_options
        )
        return _response.data

    async def patch_knowledge_base(
        self,
        knowledge_base_reference_id: str,
        *,
        app_id: typing.Optional[str] = OMIT,
        name: typing.Optional[str] = OMIT,
        tags: typing.Optional[typing.Set[str]] = OMIT,
        llm_inclusion_status: typing.Optional[LlmInclusionStatus] = OMIT,
        precondition: typing.Optional[Precondition] = OMIT,
        segment_id: typing.Optional[EntityId] = OMIT,
        refresh_frequency: typing.Optional[KnowledgeBaseRefreshFrequency] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> KnowledgeBaseResponse:
        """
        Update mutable knowledge base fields

        The `appId` field can be provided to update a knowledge base owned by a different app.
        All other fields will overwrite the existing value on the knowledge base only if provided.

        Parameters
        ----------
        knowledge_base_reference_id : str
            The reference ID of the knowledge base to patch.

        app_id : typing.Optional[str]
            The App ID of the knowledge base to patch. If not provided the ID of the calling app will be used.

        name : typing.Optional[str]
            The name of the knowledge base.

        tags : typing.Optional[typing.Set[str]]
            The tags of the knowledge base.

        llm_inclusion_status : typing.Optional[LlmInclusionStatus]
            Determines whether documents in the knowledge base are sent to the LLM as part of a conversation. Note that at this time knowledge bases can not be set to `ALWAYS`.

        precondition : typing.Optional[Precondition]
            The preconditions that must be met for a knowledge base to be relevant to a conversation. Can be used to restrict knowledge bases to certain types of users. A null value will remove the precondition from the knowledge base, it will be available on all conversations.

        segment_id : typing.Optional[EntityId]
            The ID of the segment that must be matched for the knowledge base to be relevant to a conversation.
            A null value will remove the segment from the knowledge base, it will be available on all conversations.

            Segments are replacing inline preconditions - a knowledge base may not have both an inline precondition and a segment.
            Inline precondition support will be removed in a future release.

        refresh_frequency : typing.Optional[KnowledgeBaseRefreshFrequency]
            How often the knowledge base should be refreshed.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        KnowledgeBaseResponse

        Examples
        --------
        import asyncio

        from mavenagi import AsyncMavenAGI

        client = AsyncMavenAGI(
            organization_id="YOUR_ORGANIZATION_ID",
            agent_id="YOUR_AGENT_ID",
            app_id="YOUR_APP_ID",
            app_secret="YOUR_APP_SECRET",
        )


        async def main() -> None:
            await client.knowledge.patch_knowledge_base(
                knowledge_base_reference_id="knowledgeBaseReferenceId",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.patch_knowledge_base(
            knowledge_base_reference_id,
            app_id=app_id,
            name=name,
            tags=tags,
            llm_inclusion_status=llm_inclusion_status,
            precondition=precondition,
            segment_id=segment_id,
            refresh_frequency=refresh_frequency,
            request_options=request_options,
        )
        return _response.data

    async def create_knowledge_base_version(
        self,
        knowledge_base_reference_id: str,
        *,
        type: KnowledgeBaseVersionType,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> KnowledgeBaseVersion:
        """
        Create a new knowledge base version.

        If an existing version is in progress, then that version will be finalized in an error state.

        Parameters
        ----------
        knowledge_base_reference_id : str
            The reference ID of the knowledge base to create a version for. All other entity ID fields are inferred from the request.

        type : KnowledgeBaseVersionType
            Indicates whether the completed version constitutes a full or partial refresh of the knowledge base. Deleting and updating documents is only supported for partial refreshes.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        KnowledgeBaseVersion

        Examples
        --------
        import asyncio

        from mavenagi import AsyncMavenAGI

        client = AsyncMavenAGI(
            organization_id="YOUR_ORGANIZATION_ID",
            agent_id="YOUR_AGENT_ID",
            app_id="YOUR_APP_ID",
            app_secret="YOUR_APP_SECRET",
        )


        async def main() -> None:
            await client.knowledge.create_knowledge_base_version(
                knowledge_base_reference_id="help-center",
                type="FULL",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create_knowledge_base_version(
            knowledge_base_reference_id, type=type, request_options=request_options
        )
        return _response.data

    async def finalize_knowledge_base_version(
        self,
        knowledge_base_reference_id: str,
        *,
        version_id: typing.Optional[EntityIdWithoutAgent] = OMIT,
        status: typing.Optional[KnowledgeBaseVersionFinalizeStatus] = OMIT,
        error_message: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> KnowledgeBaseVersion:
        """
        Finalize the latest knowledge base version. Required to indicate the version is complete. Will throw an exception if the latest version is not in progress.

        Parameters
        ----------
        knowledge_base_reference_id : str
            The reference ID of the knowledge base to finalize a version for. All other entity ID fields are inferred from the request.

        version_id : typing.Optional[EntityIdWithoutAgent]
            ID that uniquely identifies which knowledge base version to finalize. If not provided will use the most recent version of the knowledge base.

        status : typing.Optional[KnowledgeBaseVersionFinalizeStatus]
            Whether the knowledge base version processing was successful or not.

        error_message : typing.Optional[str]
            A user-facing error message that provides more details about a version failure.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        KnowledgeBaseVersion

        Examples
        --------
        import asyncio

        from mavenagi import AsyncMavenAGI
        from mavenagi.commons import EntityIdWithoutAgent

        client = AsyncMavenAGI(
            organization_id="YOUR_ORGANIZATION_ID",
            agent_id="YOUR_AGENT_ID",
            app_id="YOUR_APP_ID",
            app_secret="YOUR_APP_SECRET",
        )


        async def main() -> None:
            await client.knowledge.finalize_knowledge_base_version(
                knowledge_base_reference_id="help-center",
                version_id=EntityIdWithoutAgent(
                    type="KNOWLEDGE_BASE_VERSION",
                    reference_id="versionId",
                    app_id="maven",
                ),
                status="SUCCEEDED",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.finalize_knowledge_base_version(
            knowledge_base_reference_id,
            version_id=version_id,
            status=status,
            error_message=error_message,
            request_options=request_options,
        )
        return _response.data

    async def list_knowledge_base_versions(
        self,
        knowledge_base_reference_id: str,
        *,
        app_id: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> KnowledgeBaseVersionsListResponse:
        """
        List all active versions for a knowledge base. Returns the most recent versions first.

        Parameters
        ----------
        knowledge_base_reference_id : str
            The reference ID of the knowledge base to list versions for. All other entity ID fields are inferred from the request.

        app_id : typing.Optional[str]
            The App ID of the knowledge base. If not provided the ID of the calling app will be used.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        KnowledgeBaseVersionsListResponse

        Examples
        --------
        import asyncio

        from mavenagi import AsyncMavenAGI

        client = AsyncMavenAGI(
            organization_id="YOUR_ORGANIZATION_ID",
            agent_id="YOUR_AGENT_ID",
            app_id="YOUR_APP_ID",
            app_secret="YOUR_APP_SECRET",
        )


        async def main() -> None:
            await client.knowledge.list_knowledge_base_versions(
                knowledge_base_reference_id="knowledgeBaseReferenceId",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.list_knowledge_base_versions(
            knowledge_base_reference_id, app_id=app_id, request_options=request_options
        )
        return _response.data

    async def search_knowledge_documents(
        self,
        *,
        sort: typing.Optional[KnowledgeDocumentField] = OMIT,
        filter: typing.Optional[KnowledgeDocumentFilter] = OMIT,
        page: typing.Optional[int] = OMIT,
        size: typing.Optional[int] = OMIT,
        sort_desc: typing.Optional[bool] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> KnowledgeDocumentsResponse:
        """
        Search knowledge documents

        Parameters
        ----------
        sort : typing.Optional[KnowledgeDocumentField]

        filter : typing.Optional[KnowledgeDocumentFilter]

        page : typing.Optional[int]
            Page number to return, defaults to 0

        size : typing.Optional[int]
            The size of the page to return, defaults to 20

        sort_desc : typing.Optional[bool]
            Whether to sort descending, defaults to true

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        KnowledgeDocumentsResponse

        Examples
        --------
        import asyncio

        from mavenagi import AsyncMavenAGI

        client = AsyncMavenAGI(
            organization_id="YOUR_ORGANIZATION_ID",
            agent_id="YOUR_AGENT_ID",
            app_id="YOUR_APP_ID",
            app_secret="YOUR_APP_SECRET",
        )


        async def main() -> None:
            await client.knowledge.search_knowledge_documents()


        asyncio.run(main())
        """
        _response = await self._raw_client.search_knowledge_documents(
            sort=sort, filter=filter, page=page, size=size, sort_desc=sort_desc, request_options=request_options
        )
        return _response.data

    async def create_knowledge_document(
        self,
        knowledge_base_reference_id: str,
        *,
        knowledge_document_id: EntityIdBase,
        content_type: KnowledgeDocumentContentType,
        content: str,
        title: str,
        version_id: typing.Optional[EntityIdWithoutAgent] = OMIT,
        metadata: typing.Optional[typing.Dict[str, str]] = OMIT,
        url: typing.Optional[str] = OMIT,
        language: typing.Optional[str] = OMIT,
        created_at: typing.Optional[dt.datetime] = OMIT,
        updated_at: typing.Optional[dt.datetime] = OMIT,
        author: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> KnowledgeDocumentResponse:
        """
        Create or update a knowledge document. Requires an existing knowledge base with an in progress version.
        Will throw an exception if the latest version is not in progress.

        <Tip>
        This API maintains document version history. If for the same reference ID none of the `title`, `text`, `sourceUrl`, `metadata` fields
        have changed, a new document version will not be created. The existing version will be reused.
        </Tip>

        Parameters
        ----------
        knowledge_base_reference_id : str
            The reference ID of the knowledge base to create a document for. All other entity ID fields are inferred from the request.

        knowledge_document_id : EntityIdBase
            ID that uniquely identifies this knowledge document within its knowledge base

        content_type : KnowledgeDocumentContentType

        content : str
            The content of the document. Not shown directly to users. May be provided in HTML or markdown. HTML will be converted to markdown automatically. Images are not currently supported and will be ignored.

        title : str
            The title of the document. Will be shown as part of answers.

        version_id : typing.Optional[EntityIdWithoutAgent]
            ID that uniquely identifies which knowledge base version to create the document in. If not provided will use the most recent version of the knowledge base.

        metadata : typing.Optional[typing.Dict[str, str]]
            Metadata for the knowledge document.

        url : typing.Optional[str]
            The URL of the document. Should be visible to end users. Will be shown as part of answers. Not used for crawling.

        language : typing.Optional[str]
            The document language. Must be a valid ISO 639-1 language code.

        created_at : typing.Optional[dt.datetime]
            The time at which this document was created.

        updated_at : typing.Optional[dt.datetime]
            The time at which this document was last modified.

        author : typing.Optional[str]
            The name of the author who created this document.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        KnowledgeDocumentResponse

        Examples
        --------
        import asyncio

        from mavenagi import AsyncMavenAGI
        from mavenagi.commons import EntityIdBase, EntityIdWithoutAgent

        client = AsyncMavenAGI(
            organization_id="YOUR_ORGANIZATION_ID",
            agent_id="YOUR_AGENT_ID",
            app_id="YOUR_APP_ID",
            app_secret="YOUR_APP_SECRET",
        )


        async def main() -> None:
            await client.knowledge.create_knowledge_document(
                knowledge_base_reference_id="help-center",
                knowledge_document_id=EntityIdBase(
                    reference_id="getting-started",
                ),
                version_id=EntityIdWithoutAgent(
                    type="KNOWLEDGE_BASE_VERSION",
                    reference_id="versionId",
                    app_id="maven",
                ),
                content_type="MARKDOWN",
                content="## Getting started\\nThis is a getting started guide for the help center.",
                title="Getting started",
                metadata={"category": "getting-started"},
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create_knowledge_document(
            knowledge_base_reference_id,
            knowledge_document_id=knowledge_document_id,
            content_type=content_type,
            content=content,
            title=title,
            version_id=version_id,
            metadata=metadata,
            url=url,
            language=language,
            created_at=created_at,
            updated_at=updated_at,
            author=author,
            request_options=request_options,
        )
        return _response.data

    async def delete_knowledge_document(
        self,
        knowledge_base_reference_id: str,
        knowledge_document_reference_id: str,
        *,
        version_id: EntityIdWithoutAgent,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> None:
        """
        Delete knowledge document from a specific version.
        Requires an existing knowledge base with an in progress version of type PARTIAL. Will throw an exception if the version is not in progress.

        Parameters
        ----------
        knowledge_base_reference_id : str
            The reference ID of the knowledge base that contains the document to delete. All other entity ID fields are inferred from the request

        knowledge_document_reference_id : str
            The reference ID of the knowledge document to delete. All other entity ID fields are inferred from the request.

        version_id : EntityIdWithoutAgent
            ID that uniquely identifies which knowledge base version to delete the document from.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        import asyncio

        from mavenagi import AsyncMavenAGI
        from mavenagi.commons import EntityIdWithoutAgent

        client = AsyncMavenAGI(
            organization_id="YOUR_ORGANIZATION_ID",
            agent_id="YOUR_AGENT_ID",
            app_id="YOUR_APP_ID",
            app_secret="YOUR_APP_SECRET",
        )


        async def main() -> None:
            await client.knowledge.delete_knowledge_document(
                knowledge_base_reference_id="help-center",
                knowledge_document_reference_id="getting-started",
                version_id=EntityIdWithoutAgent(
                    type="KNOWLEDGE_BASE_VERSION",
                    app_id="maven",
                    reference_id="versionId",
                ),
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.delete_knowledge_document(
            knowledge_base_reference_id,
            knowledge_document_reference_id,
            version_id=version_id,
            request_options=request_options,
        )
        return _response.data

    async def get_knowledge_document(
        self,
        knowledge_base_version_reference_id: str,
        knowledge_document_reference_id: str,
        *,
        knowledge_base_version_app_id: str,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> KnowledgeDocumentResponse:
        """
        Get a knowledge document by its supplied version and document IDs. Response includes document content in markdown format.

        Parameters
        ----------
        knowledge_base_version_reference_id : str
            The reference ID of the knowledge base version that contains the document. All other entity ID fields are inferred from the request.

        knowledge_document_reference_id : str
            The reference ID of the knowledge document to get. All other entity ID fields are inferred from the request.

        knowledge_base_version_app_id : str
            The App ID of the knowledge base version.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        KnowledgeDocumentResponse

        Examples
        --------
        import asyncio

        from mavenagi import AsyncMavenAGI

        client = AsyncMavenAGI(
            organization_id="YOUR_ORGANIZATION_ID",
            agent_id="YOUR_AGENT_ID",
            app_id="YOUR_APP_ID",
            app_secret="YOUR_APP_SECRET",
        )


        async def main() -> None:
            await client.knowledge.get_knowledge_document(
                knowledge_base_version_reference_id="knowledgeBaseVersionReferenceId",
                knowledge_document_reference_id="knowledgeDocumentReferenceId",
                knowledge_base_version_app_id="knowledgeBaseVersionAppId",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get_knowledge_document(
            knowledge_base_version_reference_id,
            knowledge_document_reference_id,
            knowledge_base_version_app_id=knowledge_base_version_app_id,
            request_options=request_options,
        )
        return _response.data
