# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
import typing_extensions
from ...core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ...core.serialization import FieldMetadata


class BaseKnowledgeDocument(UniversalBaseModel):
    title: str = pydantic.Field()
    """
    The title of the document. Will be shown as part of answers.
    """

    url: typing.Optional[str] = pydantic.Field(default=None)
    """
    The URL of the document. Should be visible to end users. Will be shown as part of answers. Not used for crawling.
    """

    language: typing.Optional[str] = pydantic.Field(default=None)
    """
    The document language. Must be a valid ISO 639-1 language code.
    """

    created_at: typing_extensions.Annotated[typing.Optional[dt.datetime], FieldMetadata(alias="createdAt")] = (
        pydantic.Field(default=None)
    )
    """
    The time at which this document was created.
    """

    updated_at: typing_extensions.Annotated[typing.Optional[dt.datetime], FieldMetadata(alias="updatedAt")] = (
        pydantic.Field(default=None)
    )
    """
    The time at which this document was last modified.
    """

    author: typing.Optional[str] = pydantic.Field(default=None)
    """
    The name of the author who created this document.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
