# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ...commons.types.entity_id_without_agent import EntityIdWithoutAgent
from ...core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ...core.serialization import FieldMetadata
from .knowledge_base_version_finalize_status import KnowledgeBaseVersionFinalizeStatus


class FinalizeKnowledgeBaseVersionRequest(UniversalBaseModel):
    """
    Examples
    --------
    from mavenagi.commons import EntityIdWithoutAgent
    from mavenagi.knowledge import FinalizeKnowledgeBaseVersionRequest

    FinalizeKnowledgeBaseVersionRequest(
        version_id=EntityIdWithoutAgent(
            type="KNOWLEDGE_BASE_VERSION",
            reference_id="versionId",
            app_id="maven",
        ),
        status="SUCCEEDED",
    )
    """

    version_id: typing_extensions.Annotated[typing.Optional[EntityIdWithoutAgent], FieldMetadata(alias="versionId")] = (
        pydantic.Field(default=None)
    )
    """
    ID that uniquely identifies which knowledge base version to finalize. If not provided will use the most recent version of the knowledge base.
    """

    status: typing.Optional[KnowledgeBaseVersionFinalizeStatus] = pydantic.Field(default=None)
    """
    Whether the knowledge base version processing was successful or not.
    """

    error_message: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="errorMessage")] = (
        pydantic.Field(default=None)
    )
    """
    A user-facing error message that provides more details about a version failure.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
