# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
import typing_extensions
from ...core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ...core.serialization import FieldMetadata


class KnowledgeBaseFilter(UniversalBaseModel):
    search: typing.Optional[str] = pydantic.Field(default=None)
    """
    Full-text search query for matching knowledge bases by content. 
    When you search with this parameter, you're performing a full-text search across the knowledge title, tags and metadata.
    
    This field also supports a syntax for advanced filtering the `metadata` field.           
    
    Metadata examples:
    - `metadata:myvalue` - matches knowledge bases with any metadata field set to `myvalue`
    - `metadata.mykey:myvalue` - matches knowledge bases with a metadata field `mykey` set to `myvalue`
    - `metadata.mykey:myvalue OR anothervalue` - matches knowledge bases with a metadata field `mykey` set to `myvalue` or `anothervalue`
    - `metadata.mykey:*` - matches knowledge bases with a metadata field `mykey`
    - `-metadata:myvalue` - matches knowledge bases that do not have any metadata field set to `myvalue`
    - `_exists_:metadata` - matches knowledge bases that have any metadata field set
    """

    title: typing.Optional[str] = pydantic.Field(default=None)
    """
    Filter by title
    """

    created_after: typing_extensions.Annotated[typing.Optional[dt.datetime], FieldMetadata(alias="createdAfter")] = (
        pydantic.Field(default=None)
    )
    """
    Filter knowledge bases created on or after this timestamp
    """

    created_before: typing_extensions.Annotated[typing.Optional[dt.datetime], FieldMetadata(alias="createdBefore")] = (
        pydantic.Field(default=None)
    )
    """
    Filter knowledge bases created on or before this timestamp
    """

    app_ids: typing_extensions.Annotated[typing.Optional[typing.List[str]], FieldMetadata(alias="appIds")] = (
        pydantic.Field(default=None)
    )
    """
    Filter by app IDs
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
