# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import typing

import pydantic
from ...core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel, update_forward_refs


class KnowledgeBaseProperties(UniversalBaseModel):
    name: str = pydantic.Field()
    """
    The name of the knowledge base
    """

    precondition: typing.Optional["Precondition"] = pydantic.Field(default=None)
    """
    The preconditions that must be met for knowledge base be relevant to a conversation. Can be used to restrict knowledge bases to certain types of users.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


from ...commons.types.precondition_group import PreconditionGroup  # noqa: E402, F401, I001
from ...commons.types.precondition import Precondition  # noqa: E402, F401, I001

update_forward_refs(KnowledgeBaseProperties)
