# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import typing

import pydantic
import typing_extensions
from ...commons.types.entity_id_base import EntityIdBase
from ...core.pydantic_utilities import IS_PYDANTIC_V2
from ...core.serialization import FieldMetadata
from .knowledge_base_properties import KnowledgeBaseProperties


class KnowledgeBaseRequest(KnowledgeBaseProperties):
    """
    Examples
    --------
    from mavenagi.commons import EntityIdBase
    from mavenagi.knowledge import KnowledgeBaseRequest

    KnowledgeBaseRequest(
        knowledge_base_id=EntityIdBase(
            reference_id="help-center",
        ),
        name="Help center",
    )
    """

    knowledge_base_id: typing_extensions.Annotated[EntityIdBase, FieldMetadata(alias="knowledgeBaseId")] = (
        pydantic.Field()
    )
    """
    ID that uniquely identifies this knowledge base
    """

    metadata: typing.Optional[typing.Dict[str, str]] = pydantic.Field(default=None)
    """
    Metadata for the knowledge base.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


from ...commons.types.precondition_group import PreconditionGroup  # noqa: E402, F401, I001
