# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ...commons.types.entity_id import EntityId
from ...core.pydantic_utilities import IS_PYDANTIC_V2
from ...core.serialization import FieldMetadata
from .knowledge_base_version_request import KnowledgeBaseVersionRequest
from .knowledge_base_version_status import KnowledgeBaseVersionStatus


class KnowledgeBaseVersion(KnowledgeBaseVersionRequest):
    """
    Examples
    --------
    from mavenagi.commons import EntityId
    from mavenagi.knowledge import KnowledgeBaseVersion

    KnowledgeBaseVersion(
        version_id=EntityId(
            type="KNOWLEDGE_BASE_VERSION",
            reference_id="versionId",
            app_id="maven",
            organization_id="acme",
            agent_id="support",
        ),
        type="FULL",
        status="IN_PROGRESS",
    )
    """

    version_id: typing_extensions.Annotated[EntityId, FieldMetadata(alias="versionId")] = pydantic.Field()
    """
    The unique ID of the knowledge base version.
    """

    status: KnowledgeBaseVersionStatus = pydantic.Field()
    """
    The status of the knowledge base version
    """

    error_message: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="errorMessage")] = (
        pydantic.Field(default=None)
    )
    """
    A user-facing error message that provides more details about a version failure.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
