# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ...commons.types.entity_id_without_agent import EntityIdWithoutAgent
from ...core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ...core.serialization import FieldMetadata


class KnowledgeDeleteRequest(UniversalBaseModel):
    """
    Examples
    --------
    from mavenagi.commons import EntityIdWithoutAgent
    from mavenagi.knowledge import KnowledgeDeleteRequest

    KnowledgeDeleteRequest(
        version_id=EntityIdWithoutAgent(
            type="KNOWLEDGE_BASE_VERSION",
            app_id="maven",
            reference_id="versionId",
        ),
    )
    """

    version_id: typing_extensions.Annotated[EntityIdWithoutAgent, FieldMetadata(alias="versionId")] = pydantic.Field()
    """
    ID that uniquely identifies which knowledge base version to delete the document from.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
