# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
import typing_extensions
from ...commons.types.entity_id_without_agent import EntityIdWithoutAgent
from ...core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ...core.serialization import FieldMetadata


class KnowledgeDocumentFilter(UniversalBaseModel):
    search: typing.Optional[str] = pydantic.Field(default=None)
    """
    Full-text search query for matching knowledge documents by content. 
    When you search with this parameter, you're performing a full-text search across the knowledge document title and metadata.
    
    This field also supports a syntax for advanced filtering the `metadata` field.           
    
    Metadata examples:
    - `metadata:myvalue` - matches knowledge documents with any metadata field set to `myvalue`
    - `metadata.mykey:myvalue` - matches knowledge documents with a metadata field `mykey` set to `myvalue`
    - `metadata.mykey:myvalue OR anothervalue` - matches knowledge documents with a metadata field `mykey` set to `myvalue` or `anothervalue`
    - `metadata.mykey:*` - matches knowledge documents with a metadata field `mykey`
    - `-metadata:myvalue` - matches knowledge documents that do not have any metadata field set to `myvalue`
    - `_exists_:metadata` - matches knowledge documents that have any metadata field set
    """

    title: typing.Optional[str] = pydantic.Field(default=None)
    """
    Filter by title
    """

    created_after: typing_extensions.Annotated[typing.Optional[dt.datetime], FieldMetadata(alias="createdAfter")] = (
        pydantic.Field(default=None)
    )
    """
    Filter knowledge documents created on or after this timestamp
    """

    created_before: typing_extensions.Annotated[typing.Optional[dt.datetime], FieldMetadata(alias="createdBefore")] = (
        pydantic.Field(default=None)
    )
    """
    Filter knowledge documents created on or before this timestamp
    """

    app_ids: typing_extensions.Annotated[typing.Optional[typing.List[str]], FieldMetadata(alias="appIds")] = (
        pydantic.Field(default=None)
    )
    """
    Filter by app IDs
    """

    knowledge_base_version_id: typing_extensions.Annotated[
        typing.Optional[EntityIdWithoutAgent], FieldMetadata(alias="knowledgeBaseVersionId")
    ] = pydantic.Field(default=None)
    """
    Filter documents within the specified knowledge base version. 
    If not provided all active knowledge base versions within the agent will be searched.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
